/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : icompute.c
// Description:  do some computation of images
// Create Date: 1997.3.18
// Modification(date/where):
//
// ****************************************************************
#include <malloc.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>


#define _IMG_LIBBUILD_
#include "imgproc.h"
#include "routines.h"

// computer the differences of src1 and src2 and store it to des.
//   des = abs(src1-src2) 
//   pixel value equal to ommit (or [ommit, ommit>>8, ommit>>16] as RGB ITrueColor) is ignored
//  des will be allocated as need
// Return the summed difference vlaue if successful
// or -1 if failed

int img_different(ImageDes *des, ImageDes src1, ImageDes src2, int ommit)
{
 int x, y;
 int xsz, ysz, cnt=0;
 IBYTE *s1, *s2, *dd;
 IBYTE *s1r, *s2r, *ddr;
 IBYTE *s1g, *s2g, *ddg;
 IBYTE *s1b, *s2b, *ddb;
 
 if(!src1.alloc || !src1.load || !src2.alloc || !src2.load ||
    src1.xsize != src2.xsize || src1.ysize != src2.ysize || src1.imagetype != src2.imagetype) return -1;
 #ifdef _DEBUG
     fputs("Compute image differences...", stderr);
 #endif
 if(!AllocPicture(des, src1.xsize, src1.ysize, src1.imagetype, IFALSE, src1.numColors)) return -1;
 xsz = src1.xsize; ysz = src1.ysize;
 switch(src1.imagetype) {
     case IColor256:
     case IIndexedColor:
     case IGrey:
        s1 = src1.r; s2 = src2.r; dd = des->r; 
        cnt = 0;   ommit &= 0xff;
        for(y=0; y<ysz; y++) 
          for(x=0; x<xsz; x++) {  
            if(*s1 == ommit || *s2 == ommit) *dd = 0;
            else { *dd = (IBYTE)abs((short int)*s1 - (short int)*s2); cnt += *dd; }
            s1++; s2++; dd++;
          }
        break;
     case ITrueColor:
        s1r = src1.r; s2r = src2.r; ddr = des->r;
        s1g = src1.g; s2g = src2.g; ddg = des->g;
        s1b = src1.b; s2b = src2.b; ddb = des->b;
        ommit &= 0xffffff;    cnt = 0;
        for(y=0; y<ysz; y++) 
          for(x=0; x<xsz; x++) {  
            if(((int)*s1r | ((int)*s1g<<8) | ((int)*s1b<<16)) == ommit ||
               ((int)*s2r | ((int)*s2g<<8) | ((int)*s2b<<16)) == ommit   ) *ddr = *ddg = *ddb = 0;
            else { 
              *ddr = (IBYTE)abs((short int)*s1r - (short int)*s2r); cnt += *ddr;
              *ddg = (IBYTE)abs((short int)*s1g - (short int)*s2g); cnt += *ddg;
              *ddb = (IBYTE)abs((short int)*s1b - (short int)*s2b); cnt += *ddb;
            }
            s1r++; s2r++; ddr++;
            s1g++; s2g++; ddg++;
            s1b++; s2b++; ddb++;
          }
        break;
 }
 des->load = ITRUE;
 des->transparent = src1.transparent;
 des->trans = src1.trans;
 des->background = src1.background;
 des->back = src1.back;
 des->gamma = src1.gamma;
 #ifdef _DEBUG
    fputs("Succeed.\n", stderr);
 #endif
 return cnt;
}

