/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : id_rect.c
// Description:  draw rectangular in image
// Create Date:  1996. 12. 18
// Modification(date/where): 
//
// ****************************************************************

#include <stdlib.h>
#define _IMG_LIBBUILD_
#include "image.h"
#include "imgdraw.h"

/****************************************************************************
*
* Function:     img_draw_rect
* Parameters:   img         - image to draw the line on
*               x1,y1       - Upper Left corner of rect
*               x2,y2       - Down Right corner of rect
*               IBOOL solid
* Description:  draw rectanglar on image
*
****************************************************************************/
void img_draw_rect(ImageDes img, int x1,int y1,int x2,int y2, IBOOL solid)
{
   int t;
   int i;
   
    if(img.alloc == IFALSE) return;

    // clip it
    if(x1 > x2) {t=x1; x1 = x2; x2 =x1;}
    if(y1 > y2) {t=y1; y1 = y2; y2 =y1;}
    if(x2 < 0) return;
    if(y2 < 0) return;
    if(x1 >= img.xsize) return;
    if(y1 >= img.ysize) return;
    if(x1 < 0) x1 = 0;
    if(y1 < 0) y1 = 0;
    if(x2 >= img.xsize) x2 = img.xsize-1;
    if(y2 >= img.ysize) y2 = img.ysize-1;

    if(solid)  for(i=y1; i<=y2; i++) img_draw_line(img, x1,i, x2, i);
    else {
      img_draw_line(img, x1,y1, x2, y1);
      img_draw_line(img, x2,y1, x2, y2);
      img_draw_line(img, x2,y2, x1, y2);
      img_draw_line(img, x1,y2, x1, y1);
    }
}
