/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : idenoise.c
// Description:  eliminate point noise of a binary image
// Create Date:  1996. 10. 17
// Modification(date/where): 
//
// ****************************************************************

#include <malloc.h>
#include <stdio.h>
#include <string.h>
#define _IMG_LIBBUILD_
#include "imgproc.h"
#include "routines.h"

void _denoise(IBYTE *img, int xsize, int ysize)
{
  int i,j,k;
  int p;
  int  nb[9];
  store_addr3x3(nb, xsize);
  for(j=1, p=xsize; j<ysize-1; j++, p+=xsize)
    for(i=1; i<xsize-1; i++) 
      if(img[p+i]) {
         for(k=0; k<8&&!img[p+i+nb[k]]; k++);
         if(k > 7) img[p+i] = 0; 
        }
      else {
         for(k=0; k<8&&img[p+i+nb[k]]; k++);
         if(k > 7) img[p+i] = 255; 
        }
} 

IBOOL  image_denoise(ImageDes img)
{
  if(!img.load || img.imagetype == IColor256 || img.imagetype == IIndexedColor) return IFALSE;
  __Img_Busy(1);
  _denoise(img.r, img.xsize, img.ysize);            // calculating r planes
  __Img_Busy(img.imagetype != ITrueColor ? 95 : 33);
  if(img.imagetype == IGrey){__Img_Busy(0); return ITRUE;}
  _denoise(img.g, img.xsize, img.ysize);            // calculating g planes
  __Img_Busy(66);
  _denoise(img.b, img.xsize, img.ysize);            // calculating b planes
  __Img_Busy(0);
  return ITRUE;
}                   
