/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : ie_det3.c
// Description:  test edge detector trying trace enhanced gradient peak
// Create Date:  1996. 10. 17
// Modification(date/where): 
//
// ****************************************************************

#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#define _IMG_LIBBUILD_
#include "imgproc.h"
#include "routines.h"

void _myedgedetect3(IBYTE *img, short int *buf, int xsize, int ysize)
{
  int i,j;
  int offset1, offset2, cnt;
  short int  mtx[9], th;

    // Sobel edge detect routines
    sobel_edge(img, buf, xsize, ysize);

    for(j=0, offset1=0,cnt=0; j<ysize; j++)
      for(i=0; i<xsize; i++, offset1++) {
        buf[offset1]=(short int)abs(buf[offset1]);
        cnt+=buf[offset1];
      }
    th = (short int)(cnt*9/(xsize*ysize));
    cnt = 0;

    //blur it
    mtx[0] = 1;     mtx[1] = 1;     mtx[2] = 1;    // Average 1 1 1
    mtx[7] = 1;     mtx[8] = 1;     mtx[3] = 1;    //         1 1 1
    mtx[6] = 1;     mtx[5] = 1;     mtx[4] = 1;    //         1 1 1
    convolution3x3(img, buf+xsize*ysize, mtx, xsize, ysize);
    blank_frame(buf+xsize*ysize, xsize, ysize, 2);

    for(j=0, offset1=0, offset2=(IDWORD)xsize*ysize; j<ysize; j++)
      for(i=0; i<xsize; i++, offset1++, offset2++) {
         buf[offset1] = (short int)((long)buf[offset1]*th/(buf[offset2]+1));
         cnt += buf[offset1];
       }
    th = (short int)(cnt*9/(xsize*ysize*8));
    trace_peak(img, buf, xsize, ysize, th);
}


IBOOL  image_testedge3(ImageDes img)
{
  short int *buf;

  if(!img.load || img.imagetype == IColor256 || img.imagetype == IIndexedColor) return IFALSE;
  __Img_Busy(1);
  buf = (short int *)malloc(img.xsize*img.ysize*2*sizeof(short int));
  if(buf == NULL) { __Img_Busy(0); return IFALSE;}
  _myedgedetect3(img.r, buf, img.xsize, img.ysize);
  __Img_Busy(img.imagetype != ITrueColor ? 95 : 33);
  if(img.imagetype == IGrey){
    free(buf);
    __Img_Busy(0);
    return ITRUE;
   }
  _myedgedetect3(img.g, buf, img.xsize, img.ysize);
  __Img_Busy(66);
  _myedgedetect3(img.b, buf, img.xsize, img.ysize);
  __Img_Busy(99);
  free(buf);
  __Img_Busy(0);
  return ITRUE;
}
