/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
//****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : ie_thin.c
// Description:  edge thinning
// Create Date:  1996. 10. 7
// Modification(date/where): 
//
//****************************************************************

#include <malloc.h>
#include <stdio.h>
#include <string.h>
#define _IMG_LIBBUILD_
#include "imgproc.h"
#include "routines.h"

void thinning(IBYTE *img, IBYTE *buf, int xsize, int ysize)
{
 int i,j;
 int ix,iy,s,xx,yy,h,nrnd;
 int ybd[5],xbd[5],n[10];
 int n48,n26,n24,n46,n68,n82,n123,n345,n567,n781;

 ybd[1]=-1; ybd[2]=1; ybd[3]=0; ybd[4]=0;
 xbd[1]=0; xbd[2]=0; xbd[3]=1; xbd[4]=-1;

 for (i=0;i<ysize;i++)
   for (j=0;j<xsize;j++)
     if (*(img+i*xsize+j)) {
        *(buf+i*xsize+j)=1;
        *(img+i*xsize+j)=1;
     }
     else {
        *(buf+i*xsize+j)=0;
        *(img+i*xsize+j)=0;
     }

 do {
   s=0;
   for (h=1;h<=4;h++) {
      for (iy=1;iy<ysize-1;iy++)  {
         yy=iy+ybd[h];
         for (ix=1;ix<xsize-1;ix++)  {
            if (*(buf+iy*xsize+ix) ==0 )  continue;
            xx=ix+xbd[h];
            if (*(buf+yy*xsize+xx) != 0)  continue;
            n[3]=(unsigned int)*(buf+(iy-1)*xsize+(ix-1));
            n[2]=(unsigned int)*(buf+(iy-1)*xsize+(ix));
            n[1]=(unsigned int)*(buf+(iy-1)*xsize+(ix+1));
            n[4]=(unsigned int)*(buf+(iy)*xsize+(ix-1));
            n[8]=(unsigned int)*(buf+(iy)*xsize+(ix+1));
            n[5]=(unsigned int)*(buf+(iy+1)*xsize+(ix-1));
            n[6]=(unsigned int)*(buf+(iy+1)*xsize+(ix));
            n[7]=(unsigned int)*(buf+(iy+1)*xsize+(ix+1));

            nrnd=n[1]+n[2]+n[3]+n[4]+n[5]+n[6]+n[7]+n[8];
            if (nrnd <=1) continue;

            n48=n[4]+n[8];
            n24=n[2]+n[4];
            n26=n[2]+n[6];
            n46=n[4]+n[6];
            n68=n[6]+n[8];
            n82=n[8]+n[2];
            n123=n[1]+n[2]+n[3];
            n345=n[3]+n[4]+n[5];
            n567=n[5]+n[6]+n[7];
            n781=n[7]+n[8]+n[1];

            if ((n[2]==1)&&(n48==0)&&(n567>0)) continue;
            if ((n[6]==1)&&(n48==0)&&(n123>0)) continue;
            if ((n[8]==1)&&(n26==0)&&(n345>0)) continue;
            if ((n[4]==1)&&(n26==0)&&(n781>0)) continue;
            if ((n[5]==1)&&(n46==0)) continue;
            if ((n[7]==1)&&(n68==0)) continue;
            if ((n[1]==1)&&(n82==0)) continue;
            if ((n[3]==1)&&(n24==0)) continue;

            *(img+(iy)*xsize+(ix))=0;
            s=1;
         }
      }

      for (iy=0;iy<ysize;iy++)
         for (ix=0;ix<xsize;ix++)
            *(buf+iy*xsize+ix) = *(img+(iy)*xsize+(ix));
   }
   if (s!=1) break;
 } while(1);
        
 for (iy=0;iy<ysize;iy++)
    for (ix=0;ix<xsize;ix++)
       if (*(img+iy*xsize+ix) == 1)
           *(img+iy*xsize+ix)=255;
       else *(img+iy*xsize+ix)=0;
            
}

// thinning
IBOOL  image_thinning(ImageDes img)
{
  IBYTE *buf;

  if(!img.load || img.imagetype == IColor256 || img.imagetype == IIndexedColor) return IFALSE;
  __Img_Busy(1);
  buf = (IBYTE *)malloc(img.xsize*img.ysize);
  if(buf == NULL) { __Img_Busy(0); return IFALSE;}
  thinning(img.r, buf, img.xsize, img.ysize);
  __Img_Busy(img.imagetype != ITrueColor ? 95 : 33);
  if(img.imagetype == IGrey){
    free(buf);
    __Img_Busy(0);
    return ITRUE;
   }
  thinning(img.g, buf, img.xsize, img.ysize);
  __Img_Busy(66);
  thinning(img.b, buf, img.xsize, img.ysize);
  __Img_Busy(99);
  free(buf);
  __Img_Busy(0);
  return ITRUE;
}

