/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
//****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : ihisto.c
// Description:  histogram process
// Create Date:  1996. 10. 7
// Modification(date/where): 
//
//****************************************************************

#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#define _IMG_LIBBUILD_
#include "imgproc.h"
#include "routines.h"

//  Image Histograph linearize
//  linearize the pixels' distribution (Histograph).
void histolinearize(IBYTE *buffer, int imgWidth, int imgHeight)
{
  int i, j;
  int *histab, prob[256];
  IBYTE lookup[256];
  IBYTE *sbuff=buffer;

  histab = prob;

  memset(histab, 0, 4*256);  // Zero bins array
  for (i=0; i<imgHeight; i++)                     // count the distribution
     for (j=0; j<imgWidth; j++){
         histab[*sbuff]++;
         sbuff+=1;
     }

  prob[0] = histab[0] / 2;                // prob[]=cumulative histogram
  for(j=1; j<255; j++)
     prob[j] = prob[j-1] + histab[j];
  prob[255] = prob[255-1] + (histab[255] / 2);
  for(j=0; j<(255+1); j++)                // Assemble a lookup table
     lookup[j] = (IBYTE)((255*prob[j]) / prob[255]);
  table_mod_(lookup, buffer, imgWidth,  imgHeight);
}

IBOOL  image_histolinearize(ImageDes img)
{
  
  if(!img.load || img.imagetype == IColor256 || img.imagetype == IIndexedColor) return IFALSE;
  __Img_Busy(1);
  histolinearize(img.r, img.xsize, img.ysize);
  __Img_Busy(img.imagetype == IGrey ? 95 : 33);
  if(img.imagetype == IGrey) {__Img_Busy(0); return ITRUE;}
  histolinearize(img.g, img.xsize, img.ysize);
  __Img_Busy(66);
  histolinearize(img.b, img.xsize, img.ysize);
  __Img_Busy(0);
  return ITRUE;
}


// Histo brighten an image
// remap the distribution  to an brighter one (non-linear: square root of it)
IBOOL  histobrighten(IBYTE *buffer, int imgWidth, int imgHeight)
{
        int    i, j;
        int    dfact;
        long   *histab, *prob;
        int    number;
        IBYTE   *lookup;
        IBYTE  *sbuff=buffer;

        prob = (long *)malloc(256*(1+sizeof(long)));
        if(prob == NULL) return IFALSE;
        lookup = (IBYTE *)(prob+256);
        histab = prob;
        memset(histab, 0, sizeof(long)*256);  // Zero bins array
        for (i=0; i<imgHeight; i++)
           for (j=0; j<imgWidth; j++) {
              histab[*sbuff]++;
              sbuff++;
           }
        
        dfact = imgWidth * imgHeight;    // Calc pixels in image area
        if(dfact<16)  return IFALSE;                   // If less than 16 pixels, division by zero
        for(j=1; j<256; j++)
           prob[j] += prob[j-1];

        j=0;
        /* Assemble a lookup table */
        while(j<256) {
                number = (int)(sqrt(prob[j]/(double)dfact)*dfact);
                for(i=0; i<256; i++) if(prob[i] > number) break;
                lookup[j++] = i>255 ? 255:i;
        }
        /* Fill remainder of table with 255's */
        table_mod_(lookup, buffer, imgWidth,  imgHeight);
        return ITRUE;
}


IBOOL  image_histobrighten(ImageDes img)
{
  IBOOL rtn;

  if(!img.load || img.imagetype == IColor256 || img.imagetype == IIndexedColor) return IFALSE;
  __Img_Busy(1);
  rtn=histobrighten(img.r, img.xsize, img.ysize);
  __Img_Busy(img.imagetype == IGrey ? 95 : 33);
  if(img.imagetype == IGrey || !rtn ) {__Img_Busy(0); return ITRUE;}
  rtn=histobrighten(img.g, img.xsize, img.ysize);
  __Img_Busy(66);
  if(!rtn) {__Img_Busy(0); return rtn; }
  rtn=histobrighten(img.b, img.xsize, img.ysize);
  __Img_Busy(0);
  return rtn;
}

