/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
//****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : img_c24.c
// Description: convert image to 24 bit color image 
// Create Date: 1997. 4. 22
// Modification(date/where): 
//
//****************************************************************
#include <malloc.h>
#include <string.h>
#include <stdio.h>


#define _IMG_LIBBUILD_
#include "image.h"

// convert 24 bit color or indexed color image to grey scale image
// return ITRUE if sucessful
IBOOL img_to_color24(ImageDes *img)
{
  int i, j;
  IBYTE * cr;
  IBYTE * cg;
  IBYTE * cb;
  IMyRGB  * pal;

  #ifdef _DEBUG
     fprintf(stderr, "Converting image to Color...");
  #endif
  if(!img->alloc || !img->load) return IFALSE;
  if(img->imagetype == ITrueColor) return ITRUE;
  img->g = malloc(img->xsize * img->ysize);
  if(img->g == NULL) return IFALSE;
  img->b = malloc(img->xsize * img->ysize);
  if(img->b == NULL) {
    free(img->g);
    img->g = NULL;
    return IFALSE;
  }
  cr = img->r;   cg = img->g;   cb = img->b;
  __Img_Busy(999);
  if(img->imagetype == IGrey) {
    memcpy(cg, cr, img->xsize * img->ysize);
    memcpy(cb, cr, img->xsize * img->ysize);
  }
  else { // 256 color palette image
    pal = img->pal;
    for(i=0; i < img->ysize;  i++ ) 
       for(j=0; j<img->xsize; j++, cr++, cg++, cb++) {
          *cg = pal[*cr].g;    *cb = pal[*cr].b;   *cr = pal[*cr].r;
       }
    free(img->pal);
    img->pal = NULL;
  }
  img->imagetype = ITrueColor;
  #ifdef _DEBUG
     fprintf(stderr, "Done.\n");
  #endif
  __Img_Busy(0);
  return ITRUE;
}

