/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : imgblur.c
// Description:  blur image by some radius 
// Create Date:  1998. 12. 15
// Modification(date/where): 
// ****************************************************************

#include <stdlib.h>
#include <string.h>
#define _IMG_LIBBUILD_
#include "imgproc.h"
#include "routines.h"

// this is not a precious routine
// buf is  (max(xsize, ysize)+radius*2)*(radius*2+1)*sizeof(int);
static void __blur_image(IBYTE *img, IBYTE *buf, int xsize, int ysize, int radius)
{

   IBYTE *ptr, *p2;
   int i,j,r2;
   int acc;
   if(radius > 1) {
	   radius --;
	   ptr = img;
	   r2 = radius*2+1;
	   for(i=0; i<ysize; i++, ptr += xsize) { // xblur
		   memcpy(buf+radius, ptr, xsize);
		   memset(buf, *ptr, radius);
		   memset(buf+xsize+radius, ptr[xsize-1], radius);  // expand the image
		   p2 = ptr;
		   for(j=0,acc=0; j<r2; j++) acc+=(int)buf[j];
		   for(j=0; j<xsize;j++, p2++) {
			   *p2 = (IBYTE)(acc/r2);
			   acc += (int)buf[j+r2] - (int)buf[j];
		   }
	   }
	   ptr = img;
	   for(i=0; i<xsize; i++, ptr++) { // yblur
		   p2 = ptr;
		   for(j=0; j<ysize; j++, p2+=xsize) *(buf+j+radius)=*p2;
		   memset(buf, *ptr, radius);
		   memset(buf+ysize+radius, *(buf+ysize-1+radius), radius);  // expand the image
		   for(j=0,acc=0; j<r2; j++) acc+=(int)buf[j];
		   p2 = ptr;
		   for(j=0; j<ysize;j++, p2+=xsize) {
			   *p2 = (IBYTE)(acc/r2);
			   acc += (int)buf[j+r2] - (int)buf[j];
		   }
	   }
   }
   blur_3x3_fast(img, (short int *)buf, xsize, ysize); // radius + 
/*
   int i;
   for(i=0; i<radius; i++)  blur_3x3_fast(img, (short int *)buf, xsize, ysize); // radius + 1
*/
}



IBOOL image_blur(ImageDes img, int radius) 
{
   IBYTE *buf;

   if(!img.load || radius < 1 || img.imagetype == IColor256 || img.imagetype == IIndexedColor) return IFALSE;
   buf = malloc((max(img.xsize, img.ysize)+radius*2)*(radius*2+1)*sizeof(int));
   if(buf == NULL) return IFALSE;
   __blur_image(img.r, buf, img.xsize, img.ysize, radius);
   if(img.imagetype == ITrueColor) {
       __blur_image(img.g, buf, img.xsize, img.ysize, radius);
       __blur_image(img.b, buf, img.xsize, img.ysize, radius); 
   }
   free(buf);
   return ITRUE;
}
