/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
//****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : imgc2g.c
// Description: convert 24 bit true color image to 8 bit indexed color image 
// Create Date: 1996. 9. 25
// Modification(date/where): 
//
//****************************************************************
#include <malloc.h>
#include <string.h>
#include <stdio.h>


#define _IMG_LIBBUILD_
#include "image.h"

// convert 24 bit color or indexed color image to grey scale image
// return ITRUE if sucessful
IBOOL img_color2grey(ImageDes *img, IBOOL justPalette)
{
  int i, j, offset;
  IBYTE * cr;
  IBYTE * cg;
  IBYTE * cb;
  IMyRGB  * pal;
  IBYTE * grey;

  #ifdef _DEBUG
     fprintf(stderr, "Converting Color to IGrey...");
  #endif
  if(!img->alloc || !img->load) return IFALSE;
  if(img->imagetype == IGrey) return ITRUE;
  cr = img->r;
  if(img->imagetype == ITrueColor) {
    cg = img->g;
    cb = img->b;
    __Img_Busy(999);
    for(i=0, offset=0; i < img->ysize;  i++ ) {
       for(j=0; j<img->xsize; j++, offset++)
          // Y = 0.30*R + 0.59*G + 0.11*B
          cr[offset] = (IBYTE)((IWORD)((IWORD)cr[offset]*77+(IWORD)cg[offset]*151+(IWORD)cb[offset]*28)>>8);
    }
	if(img->transparent)
	{
        // Y = 0.30*R + 0.59*G + 0.11*B
		img->trans.Grey = (IBYTE)((IWORD)((IWORD)img->trans.Color.r*77+(IWORD)img->trans.Color.g*151+(IWORD)img->trans.Color.b*28)>>8);
	}
	if(img->background)
	{
        // Y = 0.30*R + 0.59*G + 0.11*B
		img->back.Grey = (IBYTE)((IWORD)((IWORD)img->back.Color.r*77+(IWORD)img->back.Color.g*151+(IWORD)img->back.Color.b*28)>>8);
	}
    free(img->g);
    free(img->b);
    img->g = img->b = NULL;
    img->imagetype = IGrey;
    img->numColors = 256;
  }
  // 256 color palette image
  else if(justPalette)
  {
	IBYTE gr;
    pal = img->pal;
    for(i=0; i<256; i++) 
	{
         // Y = 0.30*R + 0.59*G + 0.11*B
        gr = (IBYTE)((IWORD)((IWORD)pal[i].r*77+(IWORD)pal[i].g*151+(IWORD)pal[i].b*28)>>8);
		pal[i].r = pal[i].g = pal[i].b = gr;
	}
  }
  else // covert all
  { // 256 color palette image
    grey = (IBYTE *)malloc(256);
    if(grey == NULL) return IFALSE;
    pal = img->pal;
    for(i=0; i<256; i++) 
         // Y = 0.30*R + 0.59*G + 0.11*B
        grey[i] = (IBYTE)((IWORD)((IWORD)pal[i].r*77+(IWORD)pal[i].g*151+(IWORD)pal[i].b*28)>>8);
    for(i=0; i < img->ysize;  i++ ) 
       for(j=0; j<img->xsize; j++, cr++) 
          *cr = grey[*cr];
	if(img->transparent)
	{
		img->trans.Grey = grey[img->trans.Index];
	}
	if(img->background)
	{
		img->back.Grey = grey[img->back.Index];
	}
    free(grey);
    free(img->pal);
    img->pal = NULL;
    img->imagetype = IGrey;
    img->numColors = 256;
  }
  #ifdef _DEBUG
     fprintf(stderr, "Done.\n");
  #endif
  __Img_Busy(0);
  return ITRUE;
}

