/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : imgdraw.c
// Description:  image drawing service routines
// Create Date:  1996. 12. 18
// Modification(date/where): 
//   1998.10.27  Add img_draw_fitcolor for 256 color and grey images
// ****************************************************************

#include <stdlib.h>
#define _IMG_LIBBUILD_
#include "image.h"

#define _IDRAW_DEFINE
#include "imgdraw.h"

int  _id_draw_mode = IDRAW_OVERWRITE;
IBYTE _id_red_color = 255;
IBYTE _id_green_color = 255;
IBYTE _id_blue_color = 255;


// Set draw color
void img_draw_color(IBYTE r, IBYTE g, IBYTE b)
{
  _id_red_color = r;
  _id_green_color = g;
  _id_blue_color = b;
  return;
}

// Set draw mode
void img_draw_mode(int m)
{
  switch(m) {
    case IDRAW_OVERWRITE :
    case IDRAW_XOR :
    case IDRAW_AND :	
    case IDRAW_OR  :
      _id_draw_mode = m;
  }
  return;
}

int img_draw_fitcolor(ImageDes img, IBYTE r, IBYTE g, IBYTE b)
{
	IDWORD i, fit, tfit, k;

	if(img.imagetype == IColor256 || img.imagetype == IIndexedColor) {
		k = 0; 
		fit = ((int)r-(int)img.pal[0].r)*((int)r-(int)img.pal[0].r)
			+ ((int)g-(int)img.pal[0].g)*((int)g-(int)img.pal[0].g)
			+ ((int)b-(int)img.pal[0].b)*((int)b-(int)img.pal[0].b);
		for(i=1; i<img.numColors; i++) {
			tfit = ((int)r-(int)img.pal[i].r)*((int)r-(int)img.pal[i].r)
				 + ((int)g-(int)img.pal[i].g)*((int)g-(int)img.pal[i].g)
				 + ((int)b-(int)img.pal[i].b)*((int)b-(int)img.pal[i].b);
			if(tfit < fit) { fit = tfit; k = i; }
		}
	}
	else if(img.imagetype == IGray) k = (r*77+ g*151 + b*28)>>8;
	else k = 0;
	return k;
}


void img_draw_pixel_rgb(ImageDes img, int x, int y, IBYTE r, IBYTE g, IBYTE b)
{
  int p;
  if(img.alloc == IFALSE || 
     x < 0 || x >= img.xsize || y < 0 || y >= img.ysize) return;
  p = img.xsize*y + x;
  switch (_id_draw_mode) {
    case IDRAW_OVERWRITE :
      if(img.imagetype == ITrueColor) {
          img.g[p] = (IBYTE)g;
          img.b[p] = (IBYTE)b;
      }
      img.r[p] = (IBYTE)r;
      break;
    case IDRAW_XOR :
      if(img.imagetype == ITrueColor) {
          img.g[p] ^= (IBYTE)_id_green_color;
          img.b[p] ^= (IBYTE)_id_blue_color;
      }
      img.r[p] ^= (IBYTE)_id_red_color;
      break;
    case IDRAW_AND :	
      if(img.imagetype == ITrueColor) {
          img.g[p] &= (IBYTE)_id_green_color;
          img.b[p] &= (IBYTE)_id_blue_color;
      }
      img.r[p] &= (IBYTE)_id_red_color;
      break;
    case IDRAW_OR  :
      if(img.imagetype == ITrueColor) {
          img.g[p] |= (IBYTE)_id_green_color;
          img.b[p] |= (IBYTE)_id_blue_color;
      }
      img.r[p] |= (IBYTE)_id_red_color;
      break;
  }  
  return;
}


// draw pixel at img(x,y)
void img_draw_pixel(ImageDes img, int x, int y)
{
  int p;
  if(img.alloc == IFALSE || 
     x < 0 || x >= img.xsize || y < 0 || y >= img.ysize) return;
  p = img.xsize*y + x;
  switch (_id_draw_mode) {
    case IDRAW_OVERWRITE :
      if(img.imagetype == ITrueColor) {
          img.g[p] = (IBYTE)_id_green_color;
          img.b[p] = (IBYTE)_id_blue_color;
      }
      img.r[p] = (IBYTE)_id_red_color;
      break;
    case IDRAW_XOR :
      if(img.imagetype == ITrueColor) {
          img.g[p] ^= (IBYTE)_id_green_color;
          img.b[p] ^= (IBYTE)_id_blue_color;
      }
      img.r[p] ^= (IBYTE)_id_red_color;
      break;
    case IDRAW_AND :	
      if(img.imagetype == ITrueColor) {
          img.g[p] &= (IBYTE)_id_green_color;
          img.b[p] &= (IBYTE)_id_blue_color;
      }
      img.r[p] &= (IBYTE)_id_red_color;
      break;
    case IDRAW_OR  :
      if(img.imagetype == ITrueColor) {
          img.g[p] |= (IBYTE)_id_green_color;
          img.b[p] |= (IBYTE)_id_blue_color;
      }
      img.r[p] |= (IBYTE)_id_red_color;
      break;
  }  
  return;
}
