/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : imgfile.h
// Description:  header file for image file I/O
// Create Date: 1996.9.25
// Modification(date/where): 1996.11.23  Added system independent integer I/O routines
//
// ****************************************************************

#ifndef _INC_IMAGE_FILE
#define _INC_IMAGE_FILE

#include <stdio.h>


#include "image.h"

#ifdef  __cplusplus
extern "C" {
#endif

// imgfile.c
_IMG_DLLINTERFACE
IWORD fgetWord(FILE *fp, IBOOL intel);
_IMG_DLLINTERFACE
IDWORD fgetLong(FILE *fp, IBOOL intel);
_IMG_DLLINTERFACE
int fputWord(IWORD wd, FILE *fp, IBOOL intel);
_IMG_DLLINTERFACE
int fputLong(IDWORD dw, FILE *fp, IBOOL intel);

// filebmp.c
_IMG_DLLINTERFACE
IBOOL SaveBMP24b(const char * fname, ImageDes img);     // windows DIB  24 bits
_IMG_DLLINTERFACE
IBOOL SaveBMP8b(const char * fname, ImageDes img);      // windows DIB  8 bits
_IMG_DLLINTERFACE
IBOOL LoadBMP(const char *fname, ImageDes *img, IBOOL ping);         
_IMG_DLLINTERFACE
IBOOL LoadBMP24b(const char * fname, ImageDes *img, IBOOL ping);
_IMG_DLLINTERFACE
IBOOL LoadBMP8b(const char * fname, ImageDes *img, IBOOL ping);


// filetga.c
_IMG_DLLINTERFACE
IBOOL SaveTGA24b(const char * fname, ImageDes img);      // Targar 24 bits
_IMG_DLLINTERFACE
IBOOL LoadTGA24b(const char * fname, ImageDes *img, IBOOL ping);
//IBOOL SaveTGA16b(char * fname, ImageDes img);      // Targar 16 bits
//IBOOL LoadTGA16b(char * fname, ImageDes *img);

// filetif.c
_IMG_DLLINTERFACE
IBOOL SaveTIFF24b(const char * fname, ImageDes img);     // Tiff 24 bits
_IMG_DLLINTERFACE
IBOOL LoadTIFF24b(const char * fname, ImageDes *img, IBOOL ping);

// filepcx.c
_IMG_DLLINTERFACE
IBOOL SavePCX8b(const char * fname, ImageDes img);       // 8 bits PC Paint Brush
_IMG_DLLINTERFACE
IBOOL LoadPCX8b(const char * fname, ImageDes *img, IBOOL ping);

// fileraw.c
_IMG_DLLINTERFACE
IBOOL LoadRaw(const char * fname, ImageDes *img, int xsize, int ysize);
_IMG_DLLINTERFACE
IBOOL SaveRawGrey(const char * fname, ImageDes img);
_IMG_DLLINTERFACE
IBOOL LoadRawGrey(const char * fname, ImageDes *img, int xsize, int ysize);
_IMG_DLLINTERFACE
IBOOL SaveRawColor(const char * fname, ImageDes img);
_IMG_DLLINTERFACE
IBOOL LoadRawColor(const char * fname, ImageDes *img, int xsize, int ysize);
_IMG_DLLINTERFACE
IBOOL SaveRawASCII(const char * fname, ImageDes img);
_IMG_DLLINTERFACE
IBOOL LoadRawGreyWithHeader(const char * fname, ImageDes *img, int xsize, int ysize, int offset);

//filepsd.c
_IMG_DLLINTERFACE
IBOOL LoadPSD32b(const char * fname, ImageDes *img, IBOOL ping);

#define SaveRawGray(a,b)                   SaveRawGrey(a,b)
#define LoadRawGray(a,b,c,d)               LoadRawGrey(a,b,c,d)
#define LoadRawGrayWithHeader(a,b,c,d, e)  LoadRawGreyWithHeader(a,b,c,d,e)


#ifdef IJG_JPEG_READY
  // filejpeg.c
  //  require IJG's JPEG library Ver 6.A or later
_IMG_DLLINTERFACE
  IBOOL SaveJPEG(const char * fname, ImageDes img, int quality);
_IMG_DLLINTERFACE
  IBOOL LoadJPEG(const char * fname, ImageDes* img, IBOOL ping);
#endif

#ifdef LIBPNG_READY
  // filepng.c
  //  require libpng and zlib
_IMG_DLLINTERFACE
  IBOOL SavePNG(const char * fname, ImageDes img, IBOOL interlace);
_IMG_DLLINTERFACE
  IBOOL LoadPNG(const char * fname, ImageDes* img, IBOOL ping);
#endif

#ifdef GIF_READY
  // fileGIF.c 
  // dual to LZW patent, no SaveGIF are provided
  // LoadGIF is just provided for importing of existing images
_IMG_DLLINTERFACE
  IBOOL LoadGIF(const char *fname, ImageDes *des, IBOOL all, IBOOL ping);
#endif

// fileload.c
_IMG_DLLINTERFACE
IBOOL Loadfile_on_extension(const char *fname, ImageDes *img, int xsz, int ysz, IBOOL ping, char sepr);
_IMG_DLLINTERFACE
IBOOL Savefile_on_extension(const char *fname, ImageDes img, char sepr, int quality);

#ifdef  __cplusplus
}
#endif

#endif  //_INC_IMAGE_FILE

