/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
//****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : imghisto.c
// Description:  histogram routines 
// Create Date:  1996. 10. 2
//
//****************************************************************

#include <stdlib.h>
#include <string.h>
#include <math.h>
#define _IMG_LIBBUILD_
#include "image.h"


void count_histo(int *histo, int hsize, void *ptr, int sz, int cnt)
{
  IBYTE *b;
  IWORD *w;
  IDWORD *d;
  int i;
  
  for(i=0; i<hsize; i++) histo[i] = 0;
  switch(sz) {
    case sizeof(IBYTE):
       b = (IBYTE *)ptr;
       for(i=0; i<cnt; i++) 
          if(b[i] >= (IBYTE)hsize) histo[hsize-1]++;
          else histo[b[i]]++;
       break;
    case sizeof(IWORD):
       w = (IWORD *)ptr;
       for(i=0; i<cnt; i++) 
          if(w[i] >= (IWORD)hsize) histo[hsize-1]++;
          else histo[w[i]]++;
       break;
    case sizeof(IDWORD):
       d = (IDWORD *)ptr;
       for(i=0; i<cnt; i++) 
          if(d[i] >= (IDWORD)hsize) histo[hsize-1]++;
          else histo[d[i]]++;
       break;
    default:
       break;
  }    
  return;
}

int select_threshold(int *histo, int hsize, int scale1000)
{
  int i, th, sum;
  if(scale1000 >= 1000) return 0;
  else if( scale1000 >= 0) {
    for(i=0, sum=0; i<hsize; i++) sum+=histo[i];
    sum = sum*scale1000/1000;
    for(i=hsize-1, th=0; i>=0; i--) {
       th +=histo[i];
       if(th >= sum) break;
    }
    return i;
  }
  else {   // select volley
    return 0;
  } 
} 
