/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : imgproc.h
// Description:  image processing routines header file
// Create Date:  1993. 10. 27
// Modification(date/where):   1996.  10. 1 reformatted as standard
//
// ****************************************************************
#ifndef _INC_IMGPROC
#define _INC_IMGPROC

// imgproc.h
#include "image.h"

#ifdef  __cplusplus
extern "C" {
#endif


//******************************************************************
// filter process

// isharp.c
_IMG_DLLINTERFACE
IBOOL  image_sharpen(ImageDes image);
// igsharp.c
_IMG_DLLINTERFACE
IBOOL  image_gentlesharpen(ImageDes image);
// ilowpass.c
_IMG_DLLINTERFACE
IBOOL  image_lowpass(ImageDes image);
// isobel.c
_IMG_DLLINTERFACE
IBOOL  image_sobel(ImageDes img);
// imedian.c 
_IMG_DLLINTERFACE
IBOOL  image_median(ImageDes img, int size2);
// imajor.c
_IMG_DLLINTERFACE
IBOOL  image_majority(ImageDes img, int size2);
// imgblur.c
_IMG_DLLINTERFACE
IBOOL  image_blur(ImageDes img, int radius);
// isketch.c
_IMG_DLLINTERFACE
IBOOL  image_sketch(ImageDes img);


//******************************************************************
// general multi grey scale image process

// iclear.c
_IMG_DLLINTERFACE
IBOOL  image_clear(ImageDes image, IDWORD fills);
// imosiac.c
_IMG_DLLINTERFACE
IBOOL  image_pixellation(ImageDes image, int square_size);
_IMG_DLLINTERFACE
IBOOL  image_mosiac(ImageDes img, int square_size);
// inegtive.c
_IMG_DLLINTERFACE
IBOOL  image_negative(ImageDes image);
// icontrst.c
_IMG_DLLINTERFACE
IBOOL  image_expandcontrast(ImageDes img, int min, int max);
// isaturat.c
_IMG_DLLINTERFACE
IBOOL  image_saturation(ImageDes img, int alpha);
// ihisto.c
_IMG_DLLINTERFACE
IBOOL  image_histolinearize(ImageDes image);
_IMG_DLLINTERFACE
IBOOL  image_histobrighten(ImageDes image);
// iposter.c
_IMG_DLLINTERFACE
IBOOL  image_posterize(ImageDes image, int quantization_level);


//******************************************************************
// Transform process 
//   fast routines are using nearby value instead of interpolation
//   normal is bilinear interpolation of nearby four pixels
//   positive angle is CW rotation,
//   positive x-translation is move right
//   positive y-translation is move down

// imirror.c
_IMG_DLLINTERFACE
IBOOL  image_mirror(ImageDes img);
// iflip.c
_IMG_DLLINTERFACE
IBOOL  image_flip(ImageDes img);
// iresize.c
_IMG_DLLINTERFACE
IBOOL  image_resample(ImageDes *des, ImageDes img, int newWidth, int newHeight, IInterpType interpolation);
// irot90.c
_IMG_DLLINTERFACE
IBOOL  image_rotateccw90(ImageDes *img);
_IMG_DLLINTERFACE
IBOOL  image_rotatecw90(ImageDes *img);
// irotate.c
_IMG_DLLINTERFACE
IBOOL  image_rotate(ImageDes *des, ImageDes img,  double angle, IDWORD fills, IInterpType interpolation);
// irottran.c
_IMG_DLLINTERFACE
IBOOL  image_rotate_trans(ImageDes *des, ImageDes img, double ang, double tx, double ty, double scale, IDWORD fills, IInterpType interpolation);
_IMG_DLLINTERFACE
IBOOL  image_rotate_trans_keep_old(ImageDes *des, ImageDes img, double ang, double tx, double ty, double scale, IInterpType interpolation);
_IMG_DLLINTERFACE
IBOOL  image_rotate_trans_size(ImageDes *des, ImageDes img, double ang, double tx, double ty, double scale, IDWORD fills, IInterpType interpolation);
// itranrot.c
_IMG_DLLINTERFACE
IBOOL  image_trans_rotate(ImageDes *des, ImageDes img, double ang, double tx, double ty, double scale, IDWORD fills, IInterpType interpolation);
_IMG_DLLINTERFACE
IBOOL  image_trans_rotate_size(ImageDes *des, ImageDes img, double ang, double tx, double ty, double scale, IDWORD fills, IInterpType interpolation);
// iaffine.c
_IMG_DLLINTERFACE
IBOOL  image_full_affine(ImageDes *des, ImageDes img, double af[6], IDWORD fills, IInterpType interpolation);
_IMG_DLLINTERFACE
IBOOL  image_full_affine_size(ImageDes *des, ImageDes img, double af[6], IDWORD fills, IInterpType interpolation);
// iproject.c
_IMG_DLLINTERFACE
IBOOL  image_2D_project(ImageDes *des, ImageDes img, double pj[9], IDWORD fills, IInterpType interpolation);
_IMG_DLLINTERFACE
IBOOL  image_2D_project_size(ImageDes *des, ImageDes img, double pj[9], IDWORD fills, IInterpType interpolation);
// icylind.c
_IMG_DLLINTERFACE
IBOOL  image_cylinder_deform(ImageDes *des, ImageDes img, double cam[4], double roll, double pitch, double yaw, IDWORD fills, IInterpType interpolation);
_IMG_DLLINTERFACE
IBOOL  image_cylinder_deform_size(ImageDes *des, ImageDes img, double cam[4], double roll, double pitch, double yaw, IDWORD fills, IInterpType interpolation);


//******************************************************************
// Binarilized image process and binarilization process
//   0 means background(0), 255 means forground(1)

// ibinary.c
_IMG_DLLINTERFACE
IBOOL  image_threshold(ImageDes img, IBYTE threshold);
_IMG_DLLINTERFACE
IBOOL  image_kodalithprocess(ImageDes image, IBYTE threshold);
// itrace.c
_IMG_DLLINTERFACE
IBOOL  image_trace_art(ImageDes img);
_IMG_DLLINTERFACE
IBOOL  image_bin_trace4(ImageDes img);
_IMG_DLLINTERFACE
IBOOL  image_bin_trace8(ImageDes img);
// ie_thin.c
_IMG_DLLINTERFACE
IBOOL  image_thinning(ImageDes img);
// ishrink.c
_IMG_DLLINTERFACE
IBOOL  image_shrink(ImageDes img);
_IMG_DLLINTERFACE
IBOOL  image_expand(ImageDes img);
// idenoise.c
_IMG_DLLINTERFACE
IBOOL  image_denoise(ImageDes img);


//******************************************************************
// computations
// icompute.c
_IMG_DLLINTERFACE
int img_different(ImageDes *des, ImageDes src1, ImageDes src2, int ommit);


//******************************************************************
// extensions
// ie_dog.c
_IMG_DLLINTERFACE
IBOOL image_DOGedge(ImageDes img);
// ie_det1.c
_IMG_DLLINTERFACE
IBOOL  image_testedge1(ImageDes img);
// ie_det2.c
_IMG_DLLINTERFACE
IBOOL  image_testedge2(ImageDes img);
// ie_det3.c
_IMG_DLLINTERFACE
IBOOL  image_testedge3(ImageDes img);



/*
IBOOL  image_color_unify(ImageDes img);
IBOOL  image_colorproc2(ImageDes *img);
IBOOL  image_colorproc3(ImageDes *img);
IBOOL  image_colorproc4(ImageDes *img);
IBOOL  image_colorproc5(ImageDes *img);
*/

#ifdef  __cplusplus
}
#endif

#endif //_INC_IMGPROC
