/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : imgshade.c
// Description:  draw shadow on some area of image
// Create Date:  1998. 12. 15
// Modification(date/where): 
// ****************************************************************

#include <stdlib.h>
#define _IMG_LIBBUILD_
#include "imgdraw.h"
#include "imgproc.h"

// Draw shadow using current color on img 
IBOOL img_draw_shadow(ImageDes img, int xst, int yst, int xsz, int ysz, int radius)
{
   ImageDes mid, shade;
   int or, og, ob, om;
   IBOOL rtn;
   
   if(!img.load || xsz<=0 || ysz<=0 || radius <= 0 || img.imagetype == IColor256 || img.imagetype == IIndexedColor) return IFALSE;
   if(xst < 0) xst = 0;
   else if(xst >= img.xsize) return IFALSE;
   if(xst+xsz > img.xsize) xsz = img.xsize-xst;
   if(yst < 0) yst = 0;
   else if(yst >= img.ysize) return IFALSE;
   if(yst+ysz > img.ysize) ysz = img.ysize-yst;

   mid.alloc = shade.alloc = IFALSE;
   if(!AllocPicture(&mid, img.xsize, img.ysize, IGrey, IFALSE, 256)) return IFALSE;
   if(!AllocPicture(&shade, img.xsize, img.ysize, img.imagetype, IFALSE, img.numColors)) {
	   FreePicture(&mid);
	   return IFALSE;
   }
   mid.load = shade.load = ITRUE;
   om =  _id_draw_mode;
   or = _id_red_color;
   og = _id_green_color;
   ob = _id_blue_color;
   img_draw_mode(IDRAW_OVERWRITE);
   img_draw_color(0,0,0);
   img_draw_rect(mid, 0, 0, img.xsize, img.ysize, ITRUE);
   img_draw_color(255,255,255);
   img_draw_rect(mid, xst, yst, xsz+xst, ysz+yst, ITRUE);
   img_draw_color((IBYTE)or,(IBYTE)og,(IBYTE)ob);
   img_draw_rect(shade, 0, 0, img.xsize, img.ysize, ITRUE);
   

   if(!image_blur(mid, radius)) {
	   FreePicture(&mid);
	   FreePicture(&shade);
	   return IFALSE;
   }
   rtn = img_bitbilt_alpha(img, shade, mid.r, 
	           0, 0, img.xsize, img.ysize, 0, 0);
   FreePicture(&mid);
   FreePicture(&shade);
   return rtn;
}
   
