/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
//****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : imosiac.c
// Description:  Mosiac effect of an image
// Create Date:  1996. 10. 1
//
// Modifcations:
//		Adam Hoult- 2000, 03, 01	Instead of just returning, when
//									mosaic square is too big, we set
//									value to the biggest it can be. And
//									Carry on with that value. Also rewrote
//									The whole loop so that no gaps are left
//									Around the edges of screen (also slightly
//									faster.
//****************************************************************

#include <malloc.h>
#include <stdio.h>
#include <string.h>
#define _IMG_LIBBUILD_
#include "imgproc.h"

//  calculate block styled image
//  also called as Mosiac Effect
IBOOL pixellize(IBYTE *buffer, int imgWidth, int imgHeight, int value)
{
        IBYTE  *ssbuf;
        unsigned int sum;
        int position1, position2;
        unsigned int square;
        int i, j, k;
        int small_dimen, yy;
        int actualwidth, actualheight;
        ssbuf = buffer;
        small_dimen = (imgWidth<imgHeight) ? imgWidth : imgHeight;      // Get smallest dimension
        if (value > small_dimen) value = small_dimen;

		j=0;
		do{
			position1=0;
			position2=0;
			k=0;
			do{
				//Sum the pixels within the block.
				yy=0;
				square=0;
				sum=0;
				do{
					i=0;
					do{
						sum += *(ssbuf + position1 + i);
						square++;
						i++;
					}while(i<value && (k + i)<imgWidth);
					position1 += imgWidth;
					yy++;
				}while (yy<value && (j+yy)<imgHeight);
				actualwidth = i;
				actualheight = yy;
				// Set the pixels in the block to the average value
				for(yy=0; yy<actualheight; yy++) {
					memset(ssbuf+position2, sum/square, actualwidth); // Set up Hbuff 
					position2 += imgWidth;
				}
				k+=value;
				position1 = k;    // next block
				position2 = k;
			}while (k<imgWidth);
			ssbuf += (long)imgWidth * (long)value;
			j+=value;
		}while (j<imgHeight);
        return ITRUE;
}

IBOOL image_pixellation(ImageDes img, int square_size)
{
  IBOOL rtn;
  if(!img.load || img.imagetype == IColor256 || img.imagetype == IIndexedColor) return IFALSE;
  __Img_Busy(1);
  rtn = pixellize(img.r, img.xsize, img.ysize, square_size); // if returned value is IFALSE
  __Img_Busy(img.imagetype == IGrey ? 95 : 33);
  if(img.imagetype == IGrey || !rtn ) {__Img_Busy(0); return rtn;}
  rtn = pixellize(img.g, img.xsize, img.ysize, square_size);
  __Img_Busy(66);
  if(!rtn) {__Img_Busy(0); return rtn; }
  rtn = pixellize(img.b, img.xsize, img.ysize, square_size);
  __Img_Busy(0);
  return rtn;
}


IBOOL image_mosiac(ImageDes img, int square_size)
{
 return image_pixellation(img, square_size);
}
