/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : iresize.c
// Description:  rsize an image by resampling it
// Create Date:  1996. 10. 7
// Modification(date/where): 
//
// ****************************************************************

#include <malloc.h>
#include <stdio.h>
#include <string.h>
#define _IMG_LIBBUILD_
#include "imgproc.h"
#include "routines.h"


IBOOL  image_resample(ImageDes *des, ImageDes img, int newWidth, int newHeight, IInterpType interpolation)
{
  if(!img.load) return IFALSE;
  __Img_Busy(1);
  if(!AllocPicture(des, newWidth, newHeight, img.imagetype, img.alpha, img.numColors)) {__Img_Busy(0); return IFALSE;}
  des->load = ITRUE;
  des->transparent = img.transparent;
  des->trans = img.trans;
  des->background = img.background;
  des->back = img.back;
  des->gamma = img.gamma;
  if(img.imagetype == IColor256 || img.imagetype == IIndexedColor) {
	  interpolation = IInterp_fast;
	  memcpy(des->pal, img.pal, 768);
  }

  switch (interpolation) {
    case IInterp_normal:   // or bilinear interpolation
	   if(des->alpha) __resample(img.a, img.xsize, img.ysize, des->a, newWidth, newHeight);
       __resample(img.r, img.xsize, img.ysize, des->r, newWidth, newHeight);
       __Img_Busy(img.imagetype != ITrueColor ? 95 : 33);
       if(img.imagetype == ITrueColor) {
         __resample(img.g, img.xsize, img.ysize, des->g, newWidth, newHeight);
         __Img_Busy(66);
         __resample(img.b, img.xsize, img.ysize, des->b, newWidth, newHeight);
         __Img_Busy(99);
       }
       break;
    case IInterp_fast  :   // or near neighbor interpolation (palette image can only do this)
	   if(des->alpha) __resample_fast(img.a, img.xsize, img.ysize, des->a, newWidth, newHeight);
       __resample_fast(img.r, img.xsize, img.ysize, des->r, newWidth, newHeight);
       __Img_Busy(img.imagetype != ITrueColor ? 95 : 33);
       if(img.imagetype == ITrueColor) {
         __resample_fast(img.g, img.xsize, img.ysize, des->g, newWidth, newHeight);
         __Img_Busy(66);
         __resample_fast(img.b, img.xsize, img.ysize, des->b, newWidth, newHeight);
         __Img_Busy(99);
       }
       break;
    case IInterp_fine  :   // or bicubic interpolation
	   if(des->alpha) __resample_fine(img.a, img.xsize, img.ysize, des->a, newWidth, newHeight);
       __resample_fine(img.r, img.xsize, img.ysize, des->r, newWidth, newHeight);
       __Img_Busy(img.imagetype != ITrueColor ? 95 : 33);
       if(img.imagetype == ITrueColor) {
         __resample_fine(img.g, img.xsize, img.ysize, des->g, newWidth, newHeight);
         __Img_Busy(66);
         __resample_fine(img.b, img.xsize, img.ysize, des->b, newWidth, newHeight);
         __Img_Busy(99);
       }
       break;
  }
  return ITRUE;
}

