/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
//****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : itrace.c
// Description:  trace edge
// Create Date:  1996. 10. 1
//
//****************************************************************

#include <malloc.h>
#include <stdio.h>
#include <string.h>
#define _IMG_LIBBUILD_
#include "imgproc.h"
#include "routines.h"

IBOOL bin_check(IBYTE *buffer, int imgWidth, int imgHeight)
{
  int i,j;
  for (i=0; i<imgHeight; i++)                   // calculate the whole average of this image
    for (j=0; j<imgWidth; j++,buffer++) {
      if(*buffer>0 && *buffer <255) return IFALSE;
    }
  return ITRUE;
}  

// tracing 4 connection edge
// where buffer should be 0/255 binary image, 0 represent background
IBOOL bintrace4con(IBYTE *buffer, int imgWidth, int imgHeight)
{ int addr[9];
  int i,j,k;
  IBYTE *sbuff;
  
  
  store_addr3x3(addr, imgWidth);
  sbuff = buffer+imgWidth;
  for (i=1; i<imgHeight-1; i++, sbuff++)                   // trace 4 connection edge
    for (j=1, sbuff++; j<imgWidth-1; j++, sbuff++) {
      if(!(*sbuff)) continue;
      for(k=0; k<8; k++) if(!(*(sbuff+addr[k]))) {*sbuff = 128; break;}  // mark edge
    }

  sbuff = buffer;
  for (i=0; i<imgHeight; i++)                    
    for (j=0; j<imgWidth; j++, sbuff++) 
      if(*sbuff == 128) *sbuff = 255;  // realize the edge
      else *sbuff = 0;
  return ITRUE;
}

// tracing 8 connection edge
// where buffer should be 0/255 binary image, 0 represent background
IBOOL bintrace8con(IBYTE *buffer, int imgWidth, int imgHeight)
{ int addr[9];
  int i,j,k;
  IBYTE *sbuff;
  IBYTE p0, p1, p2, p3, p4, p5, p6, p7; 
  
  store_addr3x3(addr, imgWidth);
  sbuff = buffer+imgWidth;
  for (i=1; i<imgHeight-1; i++, sbuff++)                   // trace 4 connection edge
    for (j=1, sbuff++; j<imgWidth-1; j++, sbuff++) {
      if(!(*sbuff)) continue;
      for(k=1; k<8; k+=2) if(!(*(sbuff+addr[k]))) {*sbuff = 128; break;}  // mark edge
    }

  sbuff = buffer;
  for (i=0; i<imgHeight; i++)                    
    for (j=0; j<imgWidth; j++, sbuff++) 
      if(*sbuff != 128) *sbuff = 0;
      
  sbuff = buffer;
  for (i=0; i<imgHeight; i++)                    
    for (j=0; j<imgWidth; j++, sbuff++) 
      if(*sbuff) {
        p0 = *(sbuff+addr[0]);     p1 = *(sbuff+addr[1]);
        p2 = *(sbuff+addr[2]);     p3 = *(sbuff+addr[3]);
        p4 = *(sbuff+addr[4]);     p5 = *(sbuff+addr[5]);
        p6 = *(sbuff+addr[6]);     p7 = *(sbuff+addr[7]);
        if(  (p1 && p3 && !p6)
           ||(p3 && p5 && !p0)
           ||(p5 && p7 && !p2)
           ||(p7 && p1 && !p4))
          *sbuff = 0;    // not a 8 connect edge
        else *sbuff = 255;
      }
  return ITRUE;
}


IBOOL trace_art_(IBYTE *buffer, int imgWidth, int imgHeight)
{
  IBYTE *sbuff;
  long sum=0, pixels;
  int i, j;
  int avg_lvl;
  short int    matrix[9];

  sbuff = buffer;
  pixels = imgWidth * imgHeight;    // how many pixels in this image

  for (i=0; i<imgHeight; i++)                   // calculate the whole average of this image
    for (j=0; j<imgWidth; j++) {
      sum += *sbuff;
      sbuff += 1;
    }
  avg_lvl = sum/pixels;     // average
  if ((avg_lvl > 255) || (avg_lvl < 0)) return IFALSE;  // calculating overflow error happend

  threshold_(buffer, (IBYTE)avg_lvl, 0, 255, imgWidth, imgHeight);
  //  matrix  is  -1 -1 -1
  //              -1  8 -1
  //              -1 -1 -1
  for (i=0; i<8; i++)  matrix[i] = -1;
  matrix[8] = 8;
  self_convolution3x3(buffer, matrix, 1, imgWidth, imgHeight);   // the matrix convolution result is just the edge
  return ITRUE;
}

// giving the edge information of an image

IBOOL image_trace_art(ImageDes img)
{
  IBOOL rtn;

  if(!img.load || img.imagetype == IColor256 || img.imagetype == IIndexedColor) return IFALSE;
  __Img_Busy(1);
  rtn=trace_art_(img.r, img.xsize, img.ysize);
  __Img_Busy(img.imagetype == IGrey ? 95 : 33);
  if(img.imagetype == IGrey || !rtn ) {__Img_Busy(0); return rtn;}
  rtn=trace_art_(img.g, img.xsize, img.ysize);
  __Img_Busy(66);
  if(!rtn) {__Img_Busy(0); return rtn; }
  rtn=trace_art_(img.b, img.xsize, img.ysize);
  __Img_Busy(0);
  return rtn;
}


// giving the edge information of an image

IBOOL image_bin_trace4(ImageDes img)
{
  if(!img.load || img.imagetype == IColor256 || img.imagetype == IIndexedColor) return IFALSE;
  __Img_Busy(1);
  bintrace4con(img.r, img.xsize, img.ysize);
  __Img_Busy(img.imagetype == IGrey ? 95 : 33);
  if(img.imagetype == IGrey) {__Img_Busy(0); return ITRUE;}
  bintrace4con(img.g, img.xsize, img.ysize);
  __Img_Busy(66);
  bintrace4con(img.b, img.xsize, img.ysize);
  __Img_Busy(0);
  return ITRUE;
}

// giving the edge information of an image

IBOOL image_bin_trace8(ImageDes img)
{
  if(!img.load || img.imagetype == IColor256 || img.imagetype == IIndexedColor) return IFALSE;
  __Img_Busy(1);
  bintrace8con(img.r, img.xsize, img.ysize);
  __Img_Busy(img.imagetype == IGrey ? 95 : 33);
  if(img.imagetype == IGrey) {__Img_Busy(0); return ITRUE;}
  bintrace8con(img.g, img.xsize, img.ysize);
  __Img_Busy(66);
  bintrace8con(img.b, img.xsize, img.ysize);
  __Img_Busy(0);
  return ITRUE;
}

