/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : mathutil.h
// Description:  some useful math routines
// Create Date:  1997. 3. 10
// ****************************************************************

#ifndef _INC_MATHUTIL
#define _INC_MATHUTIL

#ifdef  __cplusplus
extern "C" {
#endif

//binsort.c


// do binary search
// n is the size of x
// x is sorted in ascending order
// p is the value to be find
// return the position i where x[i] <= p <= x[i+1]
int r_binsearch(int n, double *x, double p);
int f_binsearch(int n, float *x, float p);
int i_binsearch(int n, int *x, int p);
int b_binsearch(int n, unsigned char *x, unsigned char p);

// sort the array x (size n) in ascending order
void r_bsort(int n, double *x);
void f_bsort(int n, float *x);
void i_bsort(int n, int *x);
void b_bsort(int n, unsigned char *x);

// m_qsort.c
void  r_qsort (int nElem, double * baseP);
void  f_qsort (int nElem, float * baseP);
void  i_qsort (int nElem, int * baseP);
void  b_qsort (int nElem, unsigned char * baseP);

// mmedian.c
// return the median value of x which is size n
double r_median(int n, double *x);
float f_median(int n, float *x);
int i_median(int n, int *x);
unsigned char b_median(int n, unsigned char *x);

// return the majority or the median if there's no majority
int i_major(int n, int *x);
unsigned char b_major(int n, unsigned char *x);


// sstat.c

// calculate average value of x[1..n],  assuming x is uniform distribution 
double r_average(int n, double *x);
float f_average(int n, float *x);

// calculate expactation  of x[1..n], distribution function is dist(x)
double r_expactation(int n, double *x, double dist(double x));
float f_expactation(int n, float *x, float dist(float x));


// calculate expactation  of x[1..n], discreate distribution function is  dist[i]
double r_expactation2(int n, double *x, double *dist);
float f_expactation2(int n, float *x, float *dist);

// calculate standard deviation of x, assuming x is uniform distribution 
double r_st_deviation(int n, double *x, int zero_exp);
float f_st_deviation(int n, float *x, int zero_exp);

// calculate standard deviation of x, assuming x is normal distribution
// using median estimation 
// IMPORTANT: x will be sorted after this !
double r_median_st_deviation(int n, double *x, int zero_exp);
float f_median_st_deviation(int n, float *x, int zero_exp);

//mat3x3.c
int __mat_3x3_is_not_degenerate(double mat[9]);
int __inv_mat_3x3(double des[9], double src[9]);
// c= a*b,  c can be the same as a or b or a new one
void __mat_mul_3x3(double a[9], double b[9], double c[9]);

void construct_project_matrix(double pj[9], double roll, double pitch, double yaw, double camA[4], double camB[4]);

#ifdef  __cplusplus
}
#endif

#endif

