/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : resample.c
// Description:  resampling image
// Create Date:  1996. 10. 28
// Modification(date/where): 
//
// ****************************************************************

#define _IMG_LIBBUILD_
#include "image.h"
#include "routines.h"
// bilinear interpolation resample
void __resample(IBYTE *src, int imgWidth, int imgHeight,
                IBYTE *des, int newWidth, int newHeight )
{       
 int i,j;
 int xx, yy, xp, yp, dx, dy;
 IBYTE *pp;
 IBYTE p00, p01, p10, p11;
 
 for(j=0; j<newHeight; j++) {
   yy = ((j*imgHeight)<<8)/newHeight;
   yp = yy>>8;  dy = yy&0xff;
   for(i=0; i<newWidth; i++, des++) {
     xx = ((i*imgWidth)<<8)/newWidth;
     xp = xx>>8; dx = xx&0xff;
     pp = src+xp+yp*imgWidth; 
     p00 = *pp;                 p10 = *(pp+1); 
     p01 = *(pp+imgWidth);      p11 = *(pp+imgWidth+1);
     *des = (IBYTE)(((p11*dx+p01*(256-dx))*dy + (p10*dx+p00*(256-dx))*(256-dy))>>16);
   }
 }  
}

// near neighbor resample
void __resample_fast(IBYTE *src, int imgWidth, int imgHeight,
                     IBYTE *des, int newWidth, int newHeight )
{       
 int i,j;
 int xp, yp;
 
 for(j=0; j<newHeight; j++) {
   yp = (((j*imgHeight)<<8)/newHeight + 128)>>8;
   for(i=0; i<newWidth; i++, des++) {
     xp = (((i*imgWidth)<<8)/newWidth + 128)>>8;
     *des = *(src+xp+yp*imgWidth); 
   }
 }  
}


// bicubic interpolation resample
void __resample_fine(IBYTE *src, int imgWidth, int imgHeight,
                     IBYTE *des, int newWidth, int newHeight )
{       
 int i,j, p;
 int xx, yy, xp, yp;
 int dx, dy, dx2, dy2, dx3, dy3, ixn;
 int m0, m1, m2, m3;
 int n0, n1, n2, n3;
 IBYTE *pa, *pb, *pc, *pd;
 
 if(imgWidth < 4 || imgHeight < 4) {
    __resample(src, imgWidth, imgHeight, des, newWidth, newHeight);
    return;
 }
   
 ixn = imgWidth-4;
 for(j=0; j<newHeight; j++) {
   yy = ((j*imgHeight)<<8)/newHeight;
   yp = yy>>8;  dy = yy&0xff;
   dy2 = (dy*dy)>>8;  dy3 = (dy2*dy)>>8;
   n0 = -dy3+2*dy2-dy;    n1 = 3*dy3-5*dy2+2*256;
   n2 = -3*dy3+4*dy2+dy;  n3 = dy3-dy2;
   if(yp == 0) pa = src+yp*imgWidth;  else pa = src+(yp-1)*imgWidth;
   pb = src+yp*imgWidth;
   if(yy < imgHeight-2) {  pc = src+(yp+1)*imgWidth;   pd = src+(yp+2)*imgWidth; }
   else if(yp < imgHeight-1) {  pc = src+(yp+1)*imgWidth; pd = pc; }
   else {   pc = src+yp*imgWidth; pd = pc; } 
   for(i=0; i<newWidth; i++, des++) {
     xx = ((i*imgWidth)<<8)/newWidth;
     xp = xx>>8; dx = xx&0xff;
     dx2 = (dx*dx)>>8;  dx3 = (dx2*dx)>>8;
     m0 = -dx3+2*dx2-dx;    m1 = 3*dx3-5*dx2+2*256;
     m2 = -3*dx3+4*dx2+dx;  m3 = dx3-dx2;
     if(xp == 0) p=0;
     else if(xp < ixn) p = xp-1;
     else p = ixn;
     *des = (IBYTE)trunc_8( ((m0*pa[p+0] + m1*pa[p+1] + m2*pa[p+2] + m3*pa[p+3])*n0 +
                            (m0*pb[p+0] + m1*pb[p+1] + m2*pb[p+2] + m3*pb[p+3])*n1 +
                            (m0*pc[p+0] + m1*pc[p+1] + m2*pc[p+2] + m3*pc[p+3])*n2 +
                            (m0*pd[p+0] + m1*pd[p+1] + m2*pd[p+2] + m3*pd[p+3])*n3   )>>18);
   }
 }  
}
