/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
// ****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : sstat.c
// Description:  simple statistical routines 
// Create Date:  1997. 3. 10
// ****************************************************************


#include <malloc.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>

#include "mathutil.h"

// calculate average value of x[1..n],  assuming x is uniform distribution 
double r_average(int n, double *x)       
{                                     
  int i;                              
  double avr;
  if(n<=0) return 0;
  for(i=0, avr=0; i<n; i++) avr += x[i];
  return avr/n;  
}                                     


// calculate average value of x[1..n],  assuming x is uniform distribution 
float f_average(int n, float *x)       
{                                     
  int i;                              
  double avr;
  if(n<=0) return 0.0;
  for(i=0, avr=0; i<n; i++) avr += x[i];
  return (float)(avr/n);  
}                                     


// calculate expactation  of x[1..n], distribution function is dist(x)
double r_expactation(int n, double *x, double dist(double x))
{                                     
  int i;                              
  double avr;
  if(n<=0) return 0.0;
  for(i=0, avr=0; i<n; i++) avr += x[i]*dist(x[i]);
  return avr/n;  
}                                     
  
// calculate expactation  of x[1..n], distribution function is dist(x)
float f_expactation(int n, float *x, float dist(float x))
{                                     
  int i;                              
  double avr;
  if(n<=0) return 0.0;
  for(i=0, avr=0; i<n; i++) avr += x[i]*dist(x[i]);
  return (float)avr/n;  
}                                     


// calculate expactation  of x[1..n], discreate distribution function is  dist[i]
double r_expactation2(int n, double *x, double *dist)
{                                     
  int i;                              
  double avr;
  if(n<=0) return 0;
  for(i=0, avr=0; i<n; i++) avr += x[i]*dist[i];
  return avr/n;  
}                                     


// calculate expactation  of x[1..n], discreate distribution function is  dist[i]
float f_expactation2(int n, float *x, float *dist)
{                                     
  int i;                              
  double avr;
  if(n<=0) return 0.0;
  for(i=0, avr=0; i<n; i++) avr += x[i]*dist[i];
  return (float)avr/n;  
}                                     



// calculate standard deviation of x, assuming x is uniform distribution 
double r_st_deviation(int n, double *x, int zero_exp)
{
  int i;
  double avr, d;
  if(n<=0) return 0;
  for(i=0, d=0; i<n; i++)   d += x[i]*x[i];
  if(zero_exp)   return sqrt(d/n);
  for(i=0, avr=0; i<n; i++)  avr += x[i];
  return sqrt(d/n - avr*avr/n); 
}

// calculate standard deviation of x, assuming x is uniform distribution 
float f_st_deviation(int n, float *x, int zero_exp)
{
  int i;
  double avr, d;
  if(n<=0) return 0.0;
  for(i=0, d=0; i<n; i++)   d += x[i]*x[i];
  if(zero_exp)     return (float)sqrt(d/n);
  for(i=0, avr=0; i<n; i++)  avr += x[i];
  return (float)sqrt(d/n - avr*avr/n); 
}


// calculate standard deviation of x, assuming x is normal distribution
// using median estimation 
// IMPORTANT: x will be destroied after this !
// Refer to P.J. Rousseeuw and A. M. Leroy,  Robust Regression and Outlier Detection. John Wiley and Sons, New York, 1987
double r_median_st_deviation(int n, double *x, int zero_exp)
{
   int i; double t;
   if(n<=0) return 0;
   r_qsort(n, x);
   if(zero_exp)  return x[n/2]*1.4826;
   //return (x[3*n/4]-x[n/4])*1.4826/2;
   t = x[n/2];
   for(i=0; i<n; i++) x[i] = fabs(x[i]-t);
   r_qsort(n, x);
   return x[n/2]*1.4826;
}

// calculate standard deviation of x, assuming x is normal distribution
// using median estimation 
// IMPORTANT: x will be destroied after this !
// Refer to P.J. Rousseeuw and A. M. Leroy,  Robust Regression and Outlier Detection. John Wiley and Sons, New York, 1987
float f_median_st_deviation(int n, float *x, int zero_exp)
{
   int i; double t;
   if(n<=0) return 0.0;
   f_qsort(n, x);
   if(zero_exp)  return (float)(x[n/2]*1.4826);
  //return (x[3*n/4]-x[n/4])*1.4826/2;
   t = x[n/2];
   for(i=0; i<n; i++) x[i] = (float)fabs(x[i]-t);
   f_qsort(n, x);
   return (float)(x[n/2]*1.4826);
}

  
