#include <malloc.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>


#include "..\proc\image.h"
#include "..\proc\imgfile.h"
#include "..\proc\imgproc.h"
#include "..\util\utility.h"

ImageDes  img;
ImageDes  des;
void __Img_Busy(int percent)
{
  if(percent > 100)    printf("Busy \b\b\b\b\b");
  else if(percent<= 0) printf("Idle \b\b\b\b\b");
  else                 printf("%3d%% \b\b\b\b\b", percent);
}            

int main(int argc, char **argv)
{
  int tmp;
  char ifname[257];
  char ofname[257];
  int xclip, yclip;
  int xst, yst;
  int xsize, ysize;
  
  ifname[0]=0;
  ofname[0]=0;
  xclip = 0; yclip = 0;
  xsize = 0; ysize = 0;
  xst = -1; yst = -1;
  fputs("Image File Clip Version 1.0a\n"
        "Released 05/25/1999, Yang YuDong.\n"
        "   yangyd@yahoo.com\n"
	    "   http://pcvideo.yeah.net\n", stderr);
  for(tmp=1; tmp <argc; tmp++)
    if(argv[tmp][0] != '/' && argv[tmp][0] != '-')
      if(!*ifname)  strcpy(ifname, argv[tmp]);
      else strcpy(ofname, argv[tmp]);
    else 
      switch (argv[tmp][1]){
       case '?' :
         fputs("Usage :  ImgClip infilename [outfilename] [options]\n", stderr);
         fputs("   Image format will be kept.\n", stderr);
         fputs("Options :  \n", stderr);
         fputs("             /? : commandline help\n", stderr);
         fputs("            /Xm : Specify clip area horizontal start \n", stderr);
         fputs("            /Ym : Specify clip area vertical start \n", stderr);
         fputs("            /Hr : Specify clip area horizontal size \n", stderr);
         fputs("            /Vr : Specify clip area vertical size \n", stderr);
         return 0;
       case 'x' :
       case 'X' :
         sscanf(argv[tmp]+2, "%d", &xst);
         break;
       case 'y' :
       case 'Y' :
         sscanf(argv[tmp]+2, "%d", &yst);
         break;
       case 'h' :
       case 'H' :
         sscanf(argv[tmp]+2, "%d", &xclip);
         break;
       case 'v' :
       case 'V' :
         sscanf(argv[tmp]+2, "%d", &yclip);
         break;
       default :
           fputs("Unknown option :", stderr); fputs(argv[tmp], stderr); fputs("\n", stderr);
           return 0;
     }
  if(!*ifname){
    fputs("Use: 'ImgClip /?' for help\n", stderr);
    return 0;
  }

  des.alloc = img.alloc=IFALSE;
  if(!Loadfile_on_extension(ifname, &img, xsize, ysize, IFALSE, WIMG_PATH_SEPR)) {
    fprintf(stderr, "Error: unable to load image '%s'\n", ifname);
    return 0;
  }
  if(xclip <= 0 || yclip <= 0 || xclip > img.xsize || yclip > img.ysize) {
    FreePicture(&img);
    fprintf(stderr, "Error: wrong destination size %dx%d\n", xclip, yclip);
    return 0;
  }

  if(xclip == img.xsize && yclip == img.ysize && !*ofname) {
    printf("Not clipped : %s\n", ifname);
    return 0;
  }  

  if(!*ofname) strcpy(ofname, ifname);
  
  if(xst < 0) xst = (img.xsize-xclip)/2;  
  if(yst < 0) yst = (img.ysize-yclip)/2;  
    
  if(!img_copyblock(&des, img, xst, yst, xclip, yclip)) {
    FreePicture(&img);
    fprintf(stderr, "Error: failed to do clip\n");
    return 0;
  }
  if(img.imagetype == IColor256 || img.imagetype == IIndexedColor) memcpy(des.pal, img.pal, 768);
 
  if(!Savefile_on_extension(ofname, des, WIMG_PATH_SEPR, 75)) {
    FreePicture(&des);
    FreePicture(&img);
    fprintf(stderr, "Error: unable to save image '%s'\n", ofname);
    return 0;
  }
  FreePicture(&des);
  FreePicture(&img);
  printf("Done %s\n", ofname);
  return 1;
}

  
