#include <malloc.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>


#include "..\proc\image.h"
#include "..\proc\imgfile.h"
#include "..\proc\imgproc.h"
#include "..\util\utility.h"

ImageDes  img;
ImageDes  des;
void __Img_Busy(int percent)
{
  if(percent > 100)    printf("Busy \b\b\b\b\b");
  else if(percent<= 0) printf("Idle \b\b\b\b\b");
  else                 printf("%3d%% \b\b\b\b\b", percent);
}            

int main(int argc, char **argv)
{
  int tmp;
  char ifname[257];
  char ofname[257];
  double xr, yr;
  int xsize, ysize;
  IBOOL zoomf=IFALSE;
  IBOOL aspect=IFALSE;
  
  fputs("Image File Strecher Version 1.2a\n"
        "Released 05/25/1999, Yang YuDong.\n"
        "   yangyd@yahoo.com\n"
	    "   http://pcvideo.yeah.net\n", stderr);
  ifname[0]=0;
  ofname[0]=0;
  xr = -1.0; yr = -1.0;
  xsize = 0; ysize = 0;
  for(tmp=1; tmp <argc; tmp++)
    if(argv[tmp][0] != '/' && argv[tmp][0] != '-')
      if(!*ifname)  strcpy(ifname, argv[tmp]);
      else strcpy(ofname, argv[tmp]);
    else 
      switch (argv[tmp][1]){
       case '?' :
         fputs("Usage :  ImgSize infilename [outfilename] [options]\n", stderr);
         fputs("Options :  \n", stderr);
         fputs("             /? : commandline help\n", stderr);
         fputs("            /Xm : source horizontal size (RAW file only)\n", stderr);
         fputs("            /Ym : source vertical size (RAW file only)\n", stderr);
         fputs("            /Hr : destination horizontal size (default to source size)\n", stderr);
         fputs("            /Vr : destination vertical size   (default to source size)\n", stderr);
         fputs("            /Z  : size value is zoom factor (default is pixel number)\n", stderr);
         fputs("            /A  : keep aspect ratio (adjust to the minimal zoom factor)\n", stderr);
         return 0;
       case 'x' :
       case 'X' :
         sscanf(argv[tmp]+2, "%d", &xsize);
         break;
       case 'y' :
       case 'Y' :
         sscanf(argv[tmp]+2, "%d", &ysize);
         break;
       case 'h' :
       case 'H' :
         sscanf(argv[tmp]+2, "%lf", &xr);
         break;
       case 'v' :
       case 'V' :
         sscanf(argv[tmp]+2, "%lf", &yr);
         break;
       case 'z' :
       case 'Z' :
           zoomf = ITRUE;
           break;
       case 'a' :
       case 'A' :
           aspect = ITRUE;
           break;
       default :
           fputs("Unknown option :", stderr); fputs(argv[tmp], stderr); fputs("\n", stderr);
           return 0;
     }
  if(!*ifname){
    fputs("Use: 'ImgSize /?' for help\n", stderr);
    return 0;
  }
  

  des.alloc = img.alloc= IFALSE;
  if(!Loadfile_on_extension(ifname, &img, xsize, ysize, IFALSE, WIMG_PATH_SEPR)) {
    fprintf(stderr, "Error: unable to load image '%s'\n", ifname);
    return 0;
  }
  
  if(zoomf) {
     if(xr < 0) xsize = img.xsize;
     else xsize = (int)(img.xsize*xr+0.5);
     if(yr < 0) ysize = img.ysize;
     else ysize = (int)(img.ysize*yr+0.5);
  }
  else {
     if(xr < 0) xsize = img.xsize;
     else xsize = (int)xr;
     if(yr < 0) ysize = img.ysize;
     else ysize = (int)yr;
  }
       
  if(xsize <= 0 || ysize <= 0) {
    FreePicture(&img);
    fprintf(stderr, "Error: wrong destination size %dx%d\n", xsize, ysize);
    return 0;
  }

  if(aspect) { // keep aspect ratio
	  xr = (double)xsize/img.xsize;
	  yr = (double)ysize/img.ysize;
     if(xr > yr) xr = yr;
	 xsize = (int)(xr*img.xsize+0.5);
	 ysize = (int)(xr*img.ysize+0.5);
  }


  if(xsize == img.xsize && ysize == img.ysize && !*ofname) {
    printf("Not stretched : %s\n", ifname);
    return 0;
  }  
  if(!*ofname) strcpy(ofname, ifname);
    
  if(!image_resample(&des, img, xsize, ysize, IInterp_normal)) {
    FreePicture(&img);
    fprintf(stderr, "Error: failed to do strech\n");
    return 0;
  }
  
  if(!Savefile_on_extension(ofname, des, WIMG_PATH_SEPR, 75)) {
    FreePicture(&des);
    FreePicture(&img);
    fprintf(stderr, "Error: unable to save image '%s'\n", ofname);
    return 0;
  }
  FreePicture(&des);
  FreePicture(&img);
  printf("Done %s\n", ofname);
  return 1;
}

  
