/****************************************************************
*   Utility routines for C                                      *
*****************************************************************
*   Miscellaneous Routines                                      *
*                                                               *
*                                     Yudong Yang               *
*     Dept. of Computer Science and Technology, TsingHua Univ.  *
*   File : utility.c                                            *
****************************************************************/
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include "utility.h"


// strip the white spaces of both sides of a string
// return length of the stripped string
int strstrip(char *str)
{
  int i, p, j;
  for(i=0, p=0, j=0; str[i] != 0; i++)
    if(isspace(str[i])) {if(p>0) str[j++] = str[i];}
    else {str[j++] = str[i]; p=j;}
  str[p] = 0;
  return p;
}

// convert string to upper case
// return the pointer to str
char *str_upr(char *str)
{
 int i;
 for(i=0; str[i] != 0; i++)
   if(islower(str[i])) str[i] = toupper(str[i]);
 return str;
}

// convert string to lower case
// return the pointer to str
char *str_lwr(char *str)
{
 int i;
 for(i=0; str[i] != 0; i++)
   if(isupper(str[i])) str[i] = tolower(str[i]);
 return str;
}

// convert first n chars of string to upper case
// return the pointer to str
char *strn_upr(char *str, int n)
{
 int i;
 for(i=0; str[i] != 0 && i<n; i++)
   if(islower(str[i])) str[i] = toupper(str[i]);
 return str;
}

// convert first n chars of string to lower case
// return the pointer to str
char *strn_lwr(char *str, int n)
{
 int i;
 for(i=0; str[i] != 0 && i<n; i++)
   if(isupper(str[i])) str[i] = tolower(str[i]);
 return str;
}

// find the first occurance of a char in string
// return the displacement of that char
//  or -1 if not find
// it differs from the standard C library routine strchr by not return a pointer
int strfindc(char * str, char ch)
{
    register int i=0;
    while(str[i] != 0 && str[i] != ch) i++;
    if(!str[i]) return(-1);
    else return i;
}

int strncpyupr(char *des, const char *src, int n)
{
	register int i;
	if(!src || !des) return 0;
	for(i=0; i<n && src[i]; i++) des[i] = toupper(src[i]);
	des[i] = 0;
	return i;
}

int strncpylwr(char *des, const char *src, int n)
{
	register int i;
	if(!src || !des) return 0;
	for(i=0; i<n && src[i]; i++) des[i] = tolower(src[i]);
	des[i] = 0;
	return i;
}

// scroll the str left by one char, fill the end with ch
char *str_scroll_left(char * str, char ch)
{
 int l;
 l = strlen(str);
 if(l == 0) return str;
 memmove(str, str+1, l-1);
 str[l-1] = ch;
 return str;
}

// scroll the str right by one char, fill the end with ch
char *str_scroll_right(char * str, char ch)
{
 int l;
 l = strlen(str);
 if(l == 0) return str;
 memmove(str+1, str, l-1);
 str[0] = ch;
 return str;
}

// get a clean string from file
// return the length of the string
int mfgets(char *buf,  FILE *fp)
{
  int i, ch;
  i = 0;
  while(1) {
    ch = getc(fp);
    if(ch == 0x0a) {
         if(i>0) {
         buf[i] = 0;
         i=strstrip(buf);
         if(i) break;
        }
     }
    else if(ch == EOF) break;
    else buf[i++] = ch;
   }
  buf[i] = 0;
  return i;
}



// filename.ext and / or \ as path separations
// and . .. as current and parent path
// should working on DOS/Windows systems
// and unix systems and URL, URI
char *get_file_extension(const char *fname, char sepr)
{
	int i,j;
	
//    strstrip(fname);
	i = strlen(fname);
	if(i == 0) return NULL;
	for(j=i-1; j>0; j--) 
	{
		if(fname[j] == '.' || fname[j] == sepr) break;
	}
	if( ( j==i-1 )  // end with dot or slash, no ext
		  ||
		(fname[j] == sepr && j<i-1) // no ext
		  || 
		(fname[j] == '.' && j<i-1 && j>0  && fname[j-1] == '.') // no ext
		  ||
		(j==0 && fname[j] != '.') // no ext
	  )
	{
		return NULL;
	}

	return (char *)(fname+j+1);
}


// append an extention to file if it doesn't contain one
// working only on DOS/Windows systems
char *append_extension(char *fname, char *ext, char sepr, int maxlth)
{
   short i,j;
   char *oldext = get_file_extension(fname, sepr);
   if(oldext) return NULL; // already has one

   i = strlen(fname);
   j = strlen(ext);
   if(!j) return NULL;
   if(i+j+2 > maxlth) return NULL; // out of buffer
   fname[i] = '.';
   memcpy(fname+i+1, ext, j+1);
   return fname+1+i;
}       

// replace the old extention of a file name or just append if it doesn't contain one
// working only on DOS/Windows systems
char *replace_extension(char *fname, char *ext, char sepr, int maxlth)
{
   short i,j;
   char *oldext = get_file_extension(fname, sepr);
   if(!oldext)
   {
	   oldext = fname+strlen(fname);
   }
   else
   {
	   oldext--; // move to the '.'
   }

   i = oldext-fname;
   j = strlen(ext);
   if(!j) return NULL;
   if(i+j+2 > maxlth) return NULL; // out of buffer
   fname[i] = '.';
   memcpy(fname+i+1, ext, j+1);
   return fname+1+i;
}       

