/****************************************************************
*   Utility routines for Microsoft C                            *
*****************************************************************
*   Miscellaneous Routines (header file)                        *
*                                                               *
*                                     Yudong Yang               *
*     Dept. of Computer Science and Technology, TsingHua Univ.  *
*   File : utility.h                                            *
****************************************************************/

#ifndef _INC_MYUTILITY
#define _INC_MYUTILITY

#include <stdio.h>
// utility.c

#ifdef  __cplusplus
extern "C" {
#endif

// strip the white spaces of both sides of a string
// return length of the stripped string
int strstrip(char *str);

// find the first occurance of a char in string
// return the displacement of that char
//  or -1 if not find
// it differs from the standard C library routine strchr by not return a pointer
int strfindc(char * str, char ch);

// convert string to upper case
// return the pointer to str
char *str_upr(char *str);

// convert string to lower case
// return the pointer to str
char *str_lwr(char *str);

// convert first n chars of string to upper case
// return the pointer to str
char *strn_upr(char *str, int n);
int strncpyupr(char *des, const char *src, int n);

// convert first n chars of string to lower case
// return the pointer to str
char *strn_lwr(char *str, int n);
int strncpylwr(char *des, const char *src, int n);

// scroll the str left by one char, fill the end with ch
char *str_scroll_left(char * str, char ch);

// scroll the str right by one char, fill the end with ch
char *str_scroll_right(char * str, char ch);

// get a clean string (stripped of white spaces at head and tail) from file
// return the length of the string
int mfgets(char *buf, FILE *fp);

//--------   file name extention handling routines --------
// filename.ext and 'sepr' as path separations
// should working on DOS/Windows systems
// and unix systems and URL, URI
// side effects: the fname will be stripped of whitespaces

// return pointer to the extension if it exist
char *get_file_extension(const char *fname, char sepr);
// append an extention to file if it doesn't contain one
char *append_extension(char *fname, char *ext, char sepr, int maxlth);
// replace the old extention of a file name or just append if it doesn't contain one
char *replace_extension(char *fname, char *ext, char sepr, int maxlth);

#ifdef  __cplusplus
}
#endif

#endif