Name ""
OutFile wimg-virtualdub.exe
CRCCheck on
InstType Normal
Icon installer.ico
LicenseText "You must read the following license before installing."
LicenseData license.txt
ComponentText "This will install the PCVideo Image Filter for VirtualDub V1.0A on your computer."
DirText "Please select the directory of where VirtualDub is installed."

UninstallText "This will uninstall PCVideo Image Filter for VirtualDub V1.0A from your system."
UninstallExeName uninst-wimg.exe
UninstallIcon uninst-2.ico

InstallDir $PROGRAMFILES\VirtualDub
InstallDirRegKey HKEY_LOCAL_MACHINE "SOFTWARE\PCVideo\Wimg-VirtualDub" "Installed"

Section "Image Filter Plugin"
SectionIn 1
SetOverwrite on
SetOutPath $INSTDIR\Plugins
File wimgfilter.vdf
File wimgreadme.txt

Section "Wimg Image Processing Library"
SectionIn 1
SetOutPath $INSTDIR
File imgproc.dll

Section -post
WriteRegStr HKEY_LOCAL_MACHINE SOFTWARE\PCVideo\Wimg-VirtualDub "Installed" $INSTDIR
WriteRegStr HKEY_LOCAL_MACHINE SOFTWARE\PCVideo\Wimg-VirtualDub "Version" "1.0A"
WriteRegStr HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\Uninstall\Wimg-VirtualDub" "DisplayName" "PCVideo Image Filter for VirtualDub 1.0A"
WriteRegStr HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\Uninstall\Wimg-VirtualDub" "UninstallString" '"$INSTDIR\uninst-wimg.exe"'
WriteRegStr HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\Uninstall\Wimg-VirtualDub" "DisplayIcon" '"$INSTDIR\uninst-wimg.exe"'
SetOutPath $INSTDIR\Plugins
MessageBox MB_OK "Installation is done. Please see readme for more information."
Exec '"notepad" "$INSTDIR\Plugins\wimgreadme.txt"'

Section Uninstall
DeleteRegKey HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\Uninstall\Wimg-VirtualDub"
DeleteRegKey HKEY_LOCAL_MACHINE SOFTWARE\PCVideo\Wimg-VirtualDub
Delete $INSTDIR\Plugins\wimgfilter.vdf
Delete $INSTDIR\Plugins\wimgreadme.txt
Delete $INSTDIR\imgproc.dll
Delete $INSTDIR\uninst-wimg.exe
