/**************************************************************************
*  Image process tool box                                                 *
*     by Yang Yudong                                                      *
*     yangyd@yahoo.com                                                    *
*                                                                         *
***************************************************************************
*  Copyright (C) 1992-1999, Yang Yudong, All rights reserved.             *
*  This file is part of Yang Yudong's image processing software package.  *
*  If you use this software, you agree to the following:                  *
*  This program package is purely experimental, and is licensed "as is".  *
*  Permission is granted to use, modify, and distribute this program      *
*  without charge for any purpose, provided this license/ disclaimer      *
*  notice appears in the copies.  No warranty or maintenance is given,    *
*  either expressed or implied.  In no event shall the author(s) be       *
*  liable to you or a third party for any special, incidental,            *
*  consequential, or other damages, arising out of the use or inability   *
*  to use the program for any purpose (or the loss of data), even if we   *
*  have been advised of such possibilities.  Any public reference or      *
*  advertisement of this source code should refer to it as Yang Yudong's  *
*  orignal.                                                               *
**************************************************************************/
//****************************************************************
//  Image process tool box
//     by Yang Yudong
//
// File : winproc.cpp
// Description:  filter interface for VirtualDub
// Create Date:  2000. 10. 29
//
//****************************************************************

#include <windows.h>
#include "vdfilter.h"
#include "resource.h"


static BOOL CenterWindow (HWND hwndChild)
{
   RECT    rChild, rParent, rWorkArea;
   int     wChild, hChild, wParent, hParent;
   int     xNew, yNew;
   BOOL  bResult;
   HWND hwndParent;

   hwndParent=GetDesktopWindow();
   // Get the Height and Width of the child window
   GetWindowRect (hwndChild, &rChild);
   wChild = rChild.right - rChild.left;
   hChild = rChild.bottom - rChild.top;

   // Get the Height and Width of the parent window
   GetWindowRect (hwndParent, &rParent);
   wParent = rParent.right - rParent.left;
   hParent = rParent.bottom - rParent.top;

   // Get the limits of the 'workarea'
   bResult = SystemParametersInfo(
      SPI_GETWORKAREA,  // system parameter to query or set
      sizeof(RECT),
      &rWorkArea,
      0);
   if (!bResult) {
      rWorkArea.left = rWorkArea.top = 0;
      rWorkArea.right = GetSystemMetrics(SM_CXSCREEN);
      rWorkArea.bottom = GetSystemMetrics(SM_CYSCREEN);
   }

   // Calculate new X position, then adjust for workarea
   xNew = rParent.left + ((wParent - wChild) /2);
   if (xNew < rWorkArea.left) {
      xNew = rWorkArea.left;
   } else if ((xNew+wChild) > rWorkArea.right) {
      xNew = rWorkArea.right - wChild;
   }

   // Calculate new Y position, then adjust for workarea
   yNew = rParent.top  + ((hParent - hChild) /2);
   if (yNew < rWorkArea.top) {
      yNew = rWorkArea.top;
   } else if ((yNew+hChild) > rWorkArea.bottom) {
      yNew = rWorkArea.bottom - hChild;
   }

   // Set it, and return
   return SetWindowPos (hwndChild, NULL, xNew, yNew, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
}


LRESULT CALLBACK filterAbout(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message) {
       case WM_INITDIALOG:
         ShowWindow (hDlg, SW_HIDE);
         CenterWindow (hDlg);
         ShowWindow (hDlg, SW_SHOW);
         return (TRUE);
      case WM_LBUTTONUP:
         EndDialog(hDlg, TRUE);
         return (TRUE);
   }
    return FALSE;
}


BOOL CALLBACK filterConfigDlgProc(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam) 
{
    MyFilterData *mfd = (MyFilterData *)GetWindowLong(hdlg, DWL_USER);
	
    switch(msg) 
	{
	case WM_INITDIALOG:
		SetWindowLong(hdlg, DWL_USER, lParam);
		mfd = (MyFilterData *)lParam;
		{
			for(int i=0; filters[i].desc; i++)
			{
				SendDlgItemMessage(hdlg, IDC_FUNCLIST, 
					CB_ADDSTRING, 
					(WPARAM) 0, (LPARAM) filters[i].desc 
					);
			}
			SendDlgItemMessage(hdlg, IDC_FUNCLIST, 
				CB_SETCURSEL, 
				(WPARAM) mfd->which, (LPARAM) 0  
				);
		}
		SetDlgItemText(hdlg, IDC_PARMSTR, 	filters[mfd->which].parmstr);
		switch(filters[mfd->which].numparm)
		{
		case 0:
			SendDlgItemMessage(hdlg, IDC_PARM1, 	WM_ENABLE,	(WPARAM) FALSE, (LPARAM) 0 );
			SendDlgItemMessage(hdlg, IDC_PARM2, 	WM_ENABLE,	(WPARAM) FALSE, (LPARAM) 0 );
			break;
		case 1:
			SendDlgItemMessage(hdlg, IDC_PARM1, 	WM_ENABLE,	(WPARAM) TRUE, (LPARAM) 0 );
			SendDlgItemMessage(hdlg, IDC_PARM2, 	WM_ENABLE,	(WPARAM) FALSE, (LPARAM) 0 );
			SetDlgItemInt(hdlg, IDC_PARM1, mfd->parm1, IFALSE);
			break;
		case 2:
		default:
			SendDlgItemMessage(hdlg, IDC_PARM1, 	WM_ENABLE,	(WPARAM) TRUE, (LPARAM) 0 );
			SendDlgItemMessage(hdlg, IDC_PARM2, 	WM_ENABLE,	(WPARAM) TRUE, (LPARAM) 0 );
			SetDlgItemInt(hdlg, IDC_PARM1, mfd->parm1, IFALSE);
			SetDlgItemInt(hdlg, IDC_PARM2, mfd->parm2, IFALSE);
			break;
		}
		if(mfd->clip)
		{
			CheckDlgButton(hdlg, IDC_CLIP, BST_CHECKED);
			SendDlgItemMessage(hdlg, IDC_TOP, 		WM_ENABLE,	(WPARAM) TRUE, (LPARAM) 0 );
			SendDlgItemMessage(hdlg, IDC_BOTTOM, 	WM_ENABLE,	(WPARAM) TRUE, (LPARAM) 0 );
			SendDlgItemMessage(hdlg, IDC_LEFT,		WM_ENABLE,	(WPARAM) TRUE, (LPARAM) 0 );
			SendDlgItemMessage(hdlg, IDC_RIGHT, 	WM_ENABLE,	(WPARAM) TRUE, (LPARAM) 0 );
		}
		else
		{
			CheckDlgButton(hdlg, IDC_CLIP, BST_UNCHECKED);
			SendDlgItemMessage(hdlg, IDC_TOP,	 	WM_ENABLE,	(WPARAM) FALSE, (LPARAM) 0 );
			SendDlgItemMessage(hdlg, IDC_BOTTOM, 	WM_ENABLE,	(WPARAM) FALSE, (LPARAM) 0 );
			SendDlgItemMessage(hdlg, IDC_LEFT,		WM_ENABLE,	(WPARAM) FALSE, (LPARAM) 0 );
			SendDlgItemMessage(hdlg, IDC_RIGHT, 	WM_ENABLE,	(WPARAM) FALSE, (LPARAM) 0 );
		}
		SetDlgItemInt(hdlg, IDC_TOP,	mfd->top, IFALSE);
		SetDlgItemInt(hdlg, IDC_BOTTOM,	mfd->bottom, IFALSE);
		SetDlgItemInt(hdlg, IDC_LEFT,	mfd->left, IFALSE);
		SetDlgItemInt(hdlg, IDC_RIGHT,	mfd->right, IFALSE);

		return TRUE;
		
	case WM_COMMAND:
		switch(wParam) 
		{
		case MAKELONG(IDC_FUNCLIST, CBN_SELCHANGE): 
			{
				int which = SendDlgItemMessage(hdlg, IDC_FUNCLIST, 
					CB_GETCURSEL, (WPARAM) 0, (LPARAM) 0 );
				if(which < 0) return TRUE; // go out
				SetDlgItemText(hdlg, IDC_PARMSTR, 	filters[which].parmstr);
				switch(filters[which].numparm)
				{
				case 0:
					SendDlgItemMessage(hdlg, IDC_PARM1, 	WM_ENABLE,	(WPARAM) FALSE, (LPARAM) 0 );
					SendDlgItemMessage(hdlg, IDC_PARM2, 	WM_ENABLE,	(WPARAM) FALSE, (LPARAM) 0 );
					break;
				case 1:
					SendDlgItemMessage(hdlg, IDC_PARM1, 	WM_ENABLE,	(WPARAM) TRUE, (LPARAM) 0 );
					SendDlgItemMessage(hdlg, IDC_PARM2, 	WM_ENABLE,	(WPARAM) FALSE, (LPARAM) 0 );
					SetDlgItemInt(hdlg, IDC_PARM1, filters[which].defaultparm1, IFALSE);
					break;
				case 2:
				default:
					SendDlgItemMessage(hdlg, IDC_PARM1, 	WM_ENABLE,	(WPARAM) TRUE, (LPARAM) 0 );
					SendDlgItemMessage(hdlg, IDC_PARM2, 	WM_ENABLE,	(WPARAM) TRUE, (LPARAM) 0 );
					SetDlgItemInt(hdlg, IDC_PARM1, filters[which].defaultparm1, IFALSE);
					SetDlgItemInt(hdlg, IDC_PARM2, filters[which].defaultparm2, IFALSE);
					break;
				}
				return TRUE;
			}
		case MAKELONG(IDC_CLIP, BN_CLICKED):
			{
				if(IsDlgButtonChecked(hdlg, IDC_CLIP))
				{
					SendDlgItemMessage(hdlg, IDC_TOP, 		WM_ENABLE,	(WPARAM) TRUE, (LPARAM) 0 );
					SendDlgItemMessage(hdlg, IDC_BOTTOM, 	WM_ENABLE,	(WPARAM) TRUE, (LPARAM) 0 );
					SendDlgItemMessage(hdlg, IDC_LEFT,		WM_ENABLE,	(WPARAM) TRUE, (LPARAM) 0 );
					SendDlgItemMessage(hdlg, IDC_RIGHT, 	WM_ENABLE,	(WPARAM) TRUE, (LPARAM) 0 );
				}
				else
				{
					SendDlgItemMessage(hdlg, IDC_TOP,	 	WM_ENABLE,	(WPARAM) FALSE, (LPARAM) 0 );
					SendDlgItemMessage(hdlg, IDC_BOTTOM, 	WM_ENABLE,	(WPARAM) FALSE, (LPARAM) 0 );
					SendDlgItemMessage(hdlg, IDC_LEFT,		WM_ENABLE,	(WPARAM) FALSE, (LPARAM) 0 );
					SendDlgItemMessage(hdlg, IDC_RIGHT, 	WM_ENABLE,	(WPARAM) FALSE, (LPARAM) 0 );
					SetDlgItemInt(hdlg, IDC_TOP,	mfd->top, IFALSE);
					SetDlgItemInt(hdlg, IDC_BOTTOM,	mfd->bottom, IFALSE);
					SetDlgItemInt(hdlg, IDC_LEFT,	mfd->left, IFALSE);
					SetDlgItemInt(hdlg, IDC_RIGHT,	mfd->right, IFALSE);
				}
				return TRUE;
			}
		case MAKELONG(IDOK, BN_CLICKED):
			{
				int which = SendDlgItemMessage(hdlg, IDC_FUNCLIST, 
					CB_GETCURSEL, (WPARAM) 0, (LPARAM) 0 );
				if(which < 0) return TRUE; // go out
				mfd->which = which;
				switch(filters[which].numparm)
				{
				case 0:
					break;
				case 1:
					mfd->parm1 = GetDlgItemInt(hdlg, IDC_PARM1, NULL, IFALSE);
					break;
				case 2:
				default:
					mfd->parm1 = GetDlgItemInt(hdlg, IDC_PARM1, NULL, IFALSE);
					mfd->parm2 = GetDlgItemInt(hdlg, IDC_PARM2, NULL, IFALSE);
					break;
				}
				if(IsDlgButtonChecked(hdlg, IDC_CLIP))
				{
					mfd->clip = true;
					mfd->top = GetDlgItemInt(hdlg, IDC_TOP, NULL, IFALSE);
					mfd->bottom = GetDlgItemInt(hdlg, IDC_BOTTOM, NULL, IFALSE);
					mfd->left = GetDlgItemInt(hdlg, IDC_LEFT, NULL, IFALSE);
					mfd->right = GetDlgItemInt(hdlg, IDC_RIGHT, NULL, IFALSE);
				}
			}
			EndDialog(hdlg, 0);
			return TRUE;
		case MAKELONG(IDCANCEL, BN_CLICKED):
			EndDialog(hdlg, 1);
			return FALSE;
		case MAKELONG(IDC_ABOUT, BN_CLICKED):
			DialogBox(mfd->hInst, MAKEINTRESOURCE(IDD_ABOUT), hdlg, (DLGPROC)filterAbout);
			return TRUE;
		}
		break;
    }
	
    return FALSE;
}


int filter_config(MyFilterData *cfg)
{
    return DialogBoxParam(cfg->hInst,
            MAKEINTRESOURCE(IDD_CONFIG), cfg->hWin,
            filterConfigDlgProc, (LPARAM)cfg);
}
