# * Deletes empty space in selected tracks
# * 
# * Version: 1.0
# * Author: Harold Linke
# * Date: August 16, 2019
# * Copyright: Harold Linke 2019
# * VEGASPython: https://www.hlinke.de/dokuwiki/doku.php?id=en:vegas_python
# * VEGASPython on Github: https://github.com/haroldlinke/VEGASPython
# * 
# * based on JSCRIPT Written By: Philip 31/08/2003
# *
# * History of Change
# * V1.00 17.08.2019 - Harold Linke - adaptation for VEGASPython


import clr
clr.AddReference('ScriptPortal.Vegas')
import ScriptPortal.Vegas
from ScriptPortal.Vegas import *

def FromVegas(pyVEGAS):

    for track in pyVEGAS.Project.Tracks:
        
        if track.Selected:
            tracktime = Timecode.FromString("00:00:00:00")
            for event in track.Events:
                print ("tracktime: ",tracktime, " event len:",event.Length)
                event.AdjustStartLength(tracktime,event.Length,True)
                tracktime = Timecode(tracktime.ToMilliseconds() + event.Length.ToMilliseconds())
                
if __name__ == "__main__":
    FromVegas(pyVEGAS)